/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.proxy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.util.logging.Logger;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import software.betamax.Configuration;
import software.betamax.internal.RecorderListener;
import software.betamax.proxy.BetamaxFilters;
import software.betamax.proxy.netty.PredicatedHttpFilters;
import software.betamax.tape.Tape;
import software.betamax.util.BetamaxMitmManager;
import software.betamax.util.ProxyOverrider;

public class ProxyServer
implements RecorderListener {
    private final Configuration configuration;
    private final ProxyOverrider proxyOverrider = new ProxyOverrider();
    private HttpProxyServer proxyServer;
    private boolean running;
    private static final Predicate<HttpRequest> NOT_CONNECT = Predicates.not(PredicatedHttpFilters.httpMethodPredicate(HttpMethod.CONNECT));
    private static final Logger LOG = Logger.getLogger(ProxyServer.class.getName());

    public ProxyServer(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void onRecorderStart(Tape tape) {
        if (!this.isRunning()) {
            this.start(tape);
        }
    }

    @Override
    public void onRecorderStop() {
        if (this.isRunning()) {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start(final Tape tape) {
        if (this.isRunning()) {
            throw new IllegalStateException("Betamax proxy server is already running");
        }
        InetSocketAddress address = new InetSocketAddress(this.configuration.getProxyHost(), this.configuration.getProxyPort());
        LOG.info(String.format("Betamax proxy is binding to %s", address));
        HttpProxyServerBootstrap proxyServerBootstrap = DefaultHttpProxyServer.bootstrap().withIdleConnectionTimeout(this.configuration.getProxyTimeoutSeconds()).withAddress(address).withTransparent(true);
        if (this.configuration.isSslEnabled()) {
            proxyServerBootstrap.withManInTheMiddle((MitmManager)new BetamaxMitmManager());
        } else {
            proxyServerBootstrap.withChainProxyManager((ChainedProxyManager)this.proxyOverrider);
        }
        if (this.configuration.getProxyUser() != null) {
            proxyServerBootstrap.withProxyAuthenticator(new ProxyAuthenticator(){

                public String getRealm() {
                    return null;
                }

                public boolean authenticate(String userName, String password) {
                    return ProxyServer.this.configuration.getProxyUser().equals(userName) && ProxyServer.this.configuration.getProxyPassword().equals(password);
                }
            });
        }
        proxyServerBootstrap.withFiltersSource((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public int getMaximumRequestBufferSizeInBytes() {
                return ProxyServer.this.configuration.getRequestBufferSize();
            }

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                BetamaxFilters filters = new BetamaxFilters(originalRequest, tape);
                return new PredicatedHttpFilters((HttpFilters)filters, (Predicate<HttpRequest>)NOT_CONNECT, originalRequest);
            }
        });
        this.proxyServer = proxyServerBootstrap.start();
        this.running = true;
        this.overrideProxySettings();
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Betamax proxy server is already stopped");
        }
        this.restoreOriginalProxySettings();
        this.proxyServer.stop();
        this.running = false;
    }

    private void overrideProxySettings() {
        this.proxyOverrider.activate(this.configuration.getProxyHost(), this.configuration.getProxyPort(), this.configuration.getIgnoreHosts());
    }

    private void restoreOriginalProxySettings() {
        this.proxyOverrider.deactivateAll();
    }
}

