/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.proxy;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.impl.ProxyUtils;
import software.betamax.encoding.DeflateEncoder;
import software.betamax.encoding.GzipEncoder;
import software.betamax.handler.NonWritableTapeException;
import software.betamax.message.Response;
import software.betamax.proxy.netty.NettyRequestAdapter;
import software.betamax.proxy.netty.NettyResponseAdapter;
import software.betamax.tape.Tape;

public class BetamaxFilters
extends HttpFiltersAdapter {
    private NettyRequestAdapter request;
    private NettyResponseAdapter upstreamResponse;
    private final Tape tape;
    private static final Logger LOG = Logger.getLogger(BetamaxFilters.class.getName());

    public BetamaxFilters(HttpRequest originalRequest, Tape tape) {
        super(originalRequest);
        this.request = NettyRequestAdapter.wrap((HttpObject)originalRequest);
        this.tape = tape;
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        try {
            HttpResponse response = null;
            if (httpObject instanceof HttpRequest) {
                this.request.copyHeaders((HttpMessage)httpObject);
            }
            if (httpObject instanceof HttpContent) {
                this.request.append((HttpContent)httpObject);
            }
            if (ProxyUtils.isLastChunk((HttpObject)httpObject)) {
                response = (HttpResponse)this.onRequestIntercepted().orNull();
            }
            if (response != null) {
                HttpHeaders.setKeepAlive((HttpMessage)response, (boolean)false);
            }
            return response;
        }
        catch (IOException e) {
            return this.createErrorResponse(e);
        }
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse) {
            this.upstreamResponse = NettyResponseAdapter.wrap(httpObject);
        }
        if (httpObject instanceof HttpContent) {
            try {
                this.upstreamResponse.append((HttpContent)httpObject);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error appending content", e);
            }
        }
        if (ProxyUtils.isLastChunk((HttpObject)httpObject)) {
            if (this.tape.isWritable()) {
                LOG.info(String.format("Recording to tape %s", this.tape.getName()));
                this.tape.record(this.request, this.upstreamResponse);
            } else {
                throw new NonWritableTapeException();
            }
        }
        return httpObject;
    }

    public HttpObject proxyToClientResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)httpObject;
            if (response.headers().contains("X-Betamax")) {
                return response;
            }
            this.setBetamaxHeader(response, "REC");
            this.setViaHeader((HttpMessage)response);
        }
        return httpObject;
    }

    private Optional<? extends FullHttpResponse> onRequestIntercepted() throws IOException {
        if (this.tape == null) {
            return Optional.of((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(403, "No tape")));
        }
        if (this.tape.isReadable() && this.tape.seek(this.request)) {
            LOG.warning(String.format("Playing back from tape %s", this.tape.getName()));
            Response recordedResponse = this.tape.play(this.request);
            DefaultFullHttpResponse response = this.playRecordedResponse(recordedResponse);
            this.setViaHeader((HttpMessage)response);
            this.setBetamaxHeader((HttpResponse)response, "PLAY");
            return Optional.of((Object)response);
        }
        LOG.warning(String.format("no matching request found on %s", this.tape.getName()));
        return Optional.absent();
    }

    private DefaultFullHttpResponse playRecordedResponse(Response recordedResponse) throws IOException {
        DefaultFullHttpResponse response;
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)recordedResponse.getStatus());
        if (recordedResponse.hasBody()) {
            ByteBuf content = this.getEncodedContent(recordedResponse);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        for (Map.Entry<String, String> header : recordedResponse.getHeaders().entrySet()) {
            response.headers().set(header.getKey(), Splitter.onPattern((String)",\\s*").split((CharSequence)header.getValue()));
        }
        return response;
    }

    private ByteBuf getEncodedContent(Response recordedResponse) throws IOException {
        String encodingHeader = recordedResponse.getHeader("Content-Encoding");
        byte[] stream = "gzip".equals(encodingHeader) ? new GzipEncoder().encode(recordedResponse.getBodyAsBinary()) : ("deflate".equals(encodingHeader) ? new DeflateEncoder().encode(recordedResponse.getBodyAsBinary()) : recordedResponse.getBodyAsBinary());
        return Unpooled.wrappedBuffer((byte[])stream);
    }

    private HttpHeaders setViaHeader(HttpMessage httpMessage) {
        return httpMessage.headers().set("Via", (Object)"Betamax");
    }

    private HttpHeaders setBetamaxHeader(HttpResponse response, String value) {
        return response.headers().set("X-Betamax", (Object)value);
    }

    private HttpResponse createErrorResponse(Throwable e) {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }
}

