/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.io;

import java.util.logging.Logger;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class FileTypeMapper {
    public static final String DEFAULT_EXTENSION = ".data";
    private static final MimeTypes MIME_TYPES = MimeTypes.getDefaultMimeTypes();
    private static final Logger LOG = Logger.getLogger(FileTypeMapper.class.getName());

    public static String filenameFor(String baseName, String contentType) {
        String filename;
        try {
            String extension = MIME_TYPES.forName(contentType).getExtension();
            filename = baseName + extension;
        }
        catch (MimeTypeException e) {
            LOG.warning(String.format("Could not get extension for %s content type: %s", contentType, e.getMessage()));
            filename = baseName + DEFAULT_EXTENSION;
        }
        return filename;
    }

    private FileTypeMapper() {
    }
}

