/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import java.util.Arrays;
import software.betamax.MatchRule;
import software.betamax.message.Request;

public enum MatchRules implements MatchRule
{
    method{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getMethod().equalsIgnoreCase(b.getMethod());
        }
    }
    ,
    uri{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getUri().equals(b.getUri());
        }
    }
    ,
    host{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getUri().getHost().equals(b.getUri().getHost());
        }
    }
    ,
    path{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getUri().getPath().equals(b.getUri().getPath());
        }
    }
    ,
    port{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getUri().getPort() == b.getUri().getPort();
        }
    }
    ,
    query{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getUri().getQuery().equals(b.getUri().getQuery());
        }
    }
    ,
    queryParams{

        @Override
        public boolean isMatch(Request a, Request b) {
            if (a.getUri().getQuery() != null && b.getUri().getQuery() != null) {
                Object[] aParameters = a.getUri().getQuery().split("&");
                Object[] bParameters = b.getUri().getQuery().split("&");
                Arrays.sort(aParameters);
                Arrays.sort(bParameters);
                return Arrays.equals(aParameters, bParameters);
            }
            return a.getUri().getQuery() == null && b.getUri().getQuery() == null;
        }
    }
    ,
    authorization{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getHeader("Authorization").equals(b.getHeader("Authorization"));
        }
    }
    ,
    accept{

        @Override
        public boolean isMatch(Request a, Request b) {
            return a.getHeader("Accept").equals(b.getHeader("Accept"));
        }
    }
    ,
    body{

        @Override
        public boolean isMatch(Request a, Request b) {
            return Arrays.equals(a.getBodyAsBinary(), b.getBodyAsBinary());
        }
    };

}

