/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Properties;
import software.betamax.ComposedMatchRule;
import software.betamax.Configuration;
import software.betamax.MatchRule;
import software.betamax.MatchRules;
import software.betamax.TapeMode;
import software.betamax.util.TypedProperties;

public class ConfigurationBuilder {
    protected File tapeRoot = new File("src/test/resources/betamax/tapes");
    protected TapeMode defaultMode = Configuration.DEFAULT_MODE;
    protected MatchRule defaultMatchRule = Configuration.DEFAULT_MATCH_RULE;
    protected ImmutableCollection<String> ignoreHosts = ImmutableList.of();
    protected boolean ignoreLocalhost;
    protected String proxyHost = "0.0.0.0";
    protected int proxyPort = 5555;
    protected String proxyUser;
    protected String proxyPassword;
    protected int proxyTimeoutSeconds = 5;
    protected int requestBufferSize = 0x800000;
    protected boolean sslEnabled;

    public Configuration build() {
        return new Configuration(this);
    }

    public ConfigurationBuilder withProperties(Properties properties) {
        if (properties.containsKey("betamax.tapeRoot")) {
            this.tapeRoot(new File(properties.getProperty("betamax.tapeRoot")));
        }
        if (properties.containsKey("betamax.defaultMode")) {
            this.defaultMode(TapeMode.valueOf(properties.getProperty("betamax.defaultMode")));
        }
        if (properties.containsKey("betamax.defaultMatchRules")) {
            List rules = Lists.transform((List)Splitter.on((String)",").splitToList((CharSequence)properties.getProperty("betamax.defaultMatchRules")), (Function)new Function<String, MatchRule>(){

                public MatchRule apply(String input) {
                    return MatchRules.valueOf(input);
                }
            });
            this.defaultMatchRule(ComposedMatchRule.of(rules));
        }
        if (properties.containsKey("betamax.ignoreHosts")) {
            this.ignoreHosts(Splitter.on((String)",").splitToList((CharSequence)properties.getProperty("betamax.ignoreHosts")));
        }
        if (properties.containsKey("betamax.ignoreLocalhost")) {
            this.ignoreLocalhost(Boolean.valueOf(properties.getProperty("betamax.ignoreLocalhost")));
        }
        if (properties.containsKey("betamax.proxyHost")) {
            this.proxyHost(properties.getProperty("betamax.proxyHost"));
        }
        if (properties.containsKey("betamax.proxyPort")) {
            this.proxyPort(TypedProperties.getInteger(properties, "betamax.proxyPort"));
        }
        if (properties.containsKey("betamax.proxyTimeoutSeconds")) {
            this.proxyTimeoutSeconds(TypedProperties.getInteger(properties, "betamax.proxyTimeoutSeconds"));
        }
        if (properties.containsKey("betamax.requestBufferSize")) {
            this.requestBufferSize(TypedProperties.getInteger(properties, "betamax.requestBufferSize"));
        }
        if (properties.containsKey("betamax.sslEnabled")) {
            this.sslEnabled(TypedProperties.getBoolean(properties, "betamax.sslEnabled"));
        }
        return this;
    }

    public ConfigurationBuilder tapeRoot(File tapeRoot) {
        this.tapeRoot = tapeRoot;
        return this;
    }

    public ConfigurationBuilder defaultMode(TapeMode defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    public ConfigurationBuilder defaultMatchRule(MatchRule defaultMatchRule) {
        this.defaultMatchRule = defaultMatchRule;
        return this;
    }

    public ConfigurationBuilder defaultMatchRules(MatchRule ... defaultMatchRules) {
        this.defaultMatchRule = ComposedMatchRule.of(defaultMatchRules);
        return this;
    }

    public ConfigurationBuilder ignoreHosts(Iterable<String> ignoreHosts) {
        this.ignoreHosts = ImmutableList.copyOf(ignoreHosts);
        return this;
    }

    public ConfigurationBuilder ignoreLocalhost(boolean ignoreLocalhost) {
        this.ignoreLocalhost = ignoreLocalhost;
        return this;
    }

    public ConfigurationBuilder proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public ConfigurationBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public ConfigurationBuilder proxyAuth(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("The required proxy username and password cannot be null");
        }
        this.proxyUser = username;
        this.proxyPassword = password;
        return this;
    }

    public ConfigurationBuilder proxyTimeoutSeconds(int proxyTimeoutSeconds) {
        this.proxyTimeoutSeconds = proxyTimeoutSeconds;
        return this;
    }

    public ConfigurationBuilder requestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    public ConfigurationBuilder sslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }
}

