/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import software.betamax.ComposedMatchRule;
import software.betamax.ConfigurationBuilder;
import software.betamax.MatchRule;
import software.betamax.MatchRules;
import software.betamax.TapeMode;
import software.betamax.internal.RecorderListener;
import software.betamax.proxy.ProxyConfigurationException;
import software.betamax.proxy.ProxyServer;
import software.betamax.tape.EntityStorage;
import software.betamax.util.Network;

public class Configuration {
    public static final String DEFAULT_TAPE_ROOT = "src/test/resources/betamax/tapes";
    public static final TapeMode DEFAULT_MODE = TapeMode.READ_ONLY;
    public static final MatchRule DEFAULT_MATCH_RULE = ComposedMatchRule.of(MatchRules.method, MatchRules.uri);
    public static final EntityStorage DEFAULT_RESPONSE_BODY_STORAGE = EntityStorage.inline;
    public static final String DEFAULT_PROXY_HOST = "0.0.0.0";
    public static final int DEFAULT_REQUEST_BUFFER_SIZE = 0x800000;
    public static final int DEFAULT_PROXY_PORT = 5555;
    public static final int DEFAULT_PROXY_TIMEOUT = 5;
    private final File tapeRoot;
    private final TapeMode defaultMode;
    private final ImmutableCollection<String> ignoreHosts;
    private final boolean ignoreLocalhost;
    private final MatchRule defaultMatchRule;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPassword;
    private final int proxyTimeoutSeconds;
    private final boolean sslEnabled;
    private final int requestBufferSize;

    protected Configuration(ConfigurationBuilder builder) {
        this.tapeRoot = builder.tapeRoot;
        this.defaultMode = builder.defaultMode;
        this.defaultMatchRule = builder.defaultMatchRule;
        this.ignoreHosts = builder.ignoreHosts;
        this.ignoreLocalhost = builder.ignoreLocalhost;
        this.proxyHost = builder.proxyHost;
        this.proxyPort = builder.proxyPort;
        this.proxyUser = builder.proxyUser;
        this.proxyPassword = builder.proxyPassword;
        this.proxyTimeoutSeconds = builder.proxyTimeoutSeconds;
        this.sslEnabled = builder.sslEnabled;
        this.requestBufferSize = builder.requestBufferSize;
    }

    public static ConfigurationBuilder builder() {
        try {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            URL propertiesFile = Configuration.class.getResource("/betamax.properties");
            if (propertiesFile != null) {
                Properties properties = new Properties();
                properties.load(propertiesFile.openStream());
                return builder.withProperties(properties);
            }
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getTapeRoot() {
        return this.tapeRoot;
    }

    public TapeMode getDefaultMode() {
        return this.defaultMode;
    }

    public MatchRule getDefaultMatchRule() {
        return this.defaultMatchRule;
    }

    public Collection<String> getIgnoreHosts() {
        if (this.isIgnoreLocalhost()) {
            return new ImmutableSet.Builder().addAll(this.ignoreHosts).addAll(Network.getLocalAddresses()).build();
        }
        return this.ignoreHosts;
    }

    public boolean isIgnoreLocalhost() {
        return this.ignoreLocalhost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getProxyTimeoutSeconds() {
        return this.proxyTimeoutSeconds;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public InetAddress getProxyHost() {
        try {
            if (this.proxyHost == null) {
                return InetAddress.getByName(DEFAULT_PROXY_HOST);
            }
            return InetAddress.getByName(this.proxyHost);
        }
        catch (UnknownHostException e) {
            throw new ProxyConfigurationException(String.format("Unable to resolve host %s", this.proxyHost), e);
        }
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public Proxy getProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyHost(), this.getProxyPort()));
    }

    public void registerListeners(Collection<RecorderListener> listeners) {
        listeners.add(new ProxyServer(this));
    }
}

