/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.PgDriverHelper;
import software.amazon.jdbc.util.PropertyUtils;

public class PgTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String SIMPLE_DS_CLASS_NAME = "org.postgresql.ds.PGSimpleDataSource";
    private static final String POOLING_DS_CLASS_NAME = "org.postgresql.ds.PGPoolingDataSource";
    private static final String CP_DS_CLASS_NAME = "org.postgresql.ds.PGConnectionPoolDataSource";
    private static final Set<String> dataSourceClassMap = new HashSet<String>(Arrays.asList("org.postgresql.ds.PGSimpleDataSource", "org.postgresql.ds.PGPoolingDataSource", "org.postgresql.ds.PGConnectionPoolDataSource"));
    private static final Set<String> PG_ALLOWED_ON_CLOSED_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(GenericTargetDriverDialect.ALLOWED_ON_CLOSED_METHODS);
            this.add(JdbcMethod.STATEMENT_CLEARWARNINGS.methodName);
            this.add(JdbcMethod.STATEMENT_GETFETCHSIZE.methodName);
            this.add(JdbcMethod.STATEMENT_GETMAXFIELDSIZE.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSETTYPE.methodName);
            this.add(JdbcMethod.STATEMENT_ISCLOSEONCOMPLETION.methodName);
            this.add(JdbcMethod.STATEMENT_CLEARBATCH.methodName);
            this.add(JdbcMethod.STATEMENT_CLOSEONCOMPLETION.methodName);
            this.add(JdbcMethod.STATEMENT_GETGENERATEDKEYS.methodName);
            this.add(JdbcMethod.STATEMENT_GETMAXROWS.methodName);
            this.add(JdbcMethod.STATEMENT_GETMORERESULTS.methodName);
            this.add(JdbcMethod.STATEMENT_GETQUERYTIMEOUT.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSET.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSETCONCURRENCY.methodName);
            this.add(JdbcMethod.STATEMENT_GETUPDATECOUNT.methodName);
            this.add(JdbcMethod.STATEMENT_GETWARNINGS.methodName);
            this.add(JdbcMethod.STATEMENT_ADDBATCH.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETARRAY.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBIGDECIMAL.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBOOLEAN.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBYTE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBYTES.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETDATE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETDOUBLE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETFLOAT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETINT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETLONG.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETOBJECT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETSHORT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETSQLXML.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETTIME.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETSTRING.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETTIMESTAMP.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_WASNULL.methodName);
            this.add(JdbcMethod.PREPAREDSTATEMENT_ADDBATCH.methodName);
            this.add(JdbcMethod.PREPAREDSTATEMENT_CLEARPARAMETERS.methodName);
        }
    });

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return dataSourceClassMap.contains(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        Boolean tcpKeepAlive = PropertyUtils.getBooleanPropertyValue(props, PropertyDefinition.TCP_KEEP_ALIVE);
        Integer loginTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.LOGIN_TIMEOUT);
        Integer connectTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.CONNECT_TIMEOUT);
        Integer socketTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.SOCKET_TIMEOUT);
        PropertyDefinition.removeAllExceptCredentials(props);
        if (tcpKeepAlive != null) {
            props.setProperty("tcpKeepAlive", String.valueOf(tcpKeepAlive));
        }
        if (loginTimeout != null) {
            props.setProperty("loginTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(loginTimeout.intValue())));
        }
        if (connectTimeout != null) {
            props.setProperty("connectTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(connectTimeout.intValue())));
        }
        if (socketTimeout != null) {
            props.setProperty("socketTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(socketTimeout.intValue())));
        }
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName;
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        helper.registerDriver();
    }

    @Override
    public Set<String> getAllowedOnConnectionMethodNames() {
        return PG_ALLOWED_ON_CLOSED_METHOD_NAMES;
    }
}

