/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.dialect.AuroraLimitlessDialect;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionContext;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterServiceImpl;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;

public class LimitlessConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(LimitlessConnectionPlugin.class.getName());
    public static final AwsWrapperProperty WAIT_FOR_ROUTER_INFO = new AwsWrapperProperty("limitlessWaitForTransactionRouterInfo", "true", "If the cache of transaction router info is empty and a new connection is made, this property toggles whether the plugin will wait and synchronously fetch transaction router info before selecting a transaction router to connect to, or to fall back to using the provided DB Shard Group endpoint URL.");
    public static final AwsWrapperProperty GET_ROUTER_RETRY_INTERVAL_MILLIS = new AwsWrapperProperty("limitlessGetTransactionRouterInfoRetryIntervalMs", "300", "Interval in millis between retries fetching Limitless Transaction Router information.");
    public static final AwsWrapperProperty GET_ROUTER_MAX_RETRIES = new AwsWrapperProperty("limitlessGetTransactionRouterInfoMaxRetries", "5", "Max number of connection retries fetching Limitless Transaction Router information.");
    public static final AwsWrapperProperty INTERVAL_MILLIS = new AwsWrapperProperty("limitlessTransactionRouterMonitorIntervalMs", "7500", "Interval in millis between polling for Limitless Transaction Routers to the database.");
    public static final AwsWrapperProperty MAX_RETRIES = new AwsWrapperProperty("limitlessConnectMaxRetries", "5", "Max number of connection retries the Limitless Connection Plugin will attempt.");
    protected final PluginService pluginService;
    protected final Properties properties;
    private final Supplier<LimitlessRouterService> limitlessRouterServiceSupplier;
    private LimitlessRouterService limitlessRouterService;
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("connect");
        }
    });

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    public LimitlessConnectionPlugin(FullServicesContainer servicesContainer, @NonNull Properties properties) {
        this(servicesContainer.getPluginService(), properties, () -> new LimitlessRouterServiceImpl(servicesContainer, properties));
    }

    public LimitlessConnectionPlugin(PluginService pluginService, @NonNull Properties properties, @NonNull Supplier<LimitlessRouterService> limitlessRouterServiceSupplier) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.limitlessRouterServiceSupplier = limitlessRouterServiceSupplier;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = null;
        Dialect dialect = this.pluginService.getDialect();
        if (!(dialect instanceof AuroraLimitlessDialect)) {
            conn = connectFunc.call();
            Dialect refreshedDialect = this.pluginService.getDialect();
            if (!(refreshedDialect instanceof AuroraLimitlessDialect)) {
                throw new UnsupportedOperationException(Messages.get("LimitlessConnectionPlugin.unsupportedDialectOrDatabase", new Object[]{refreshedDialect}));
            }
        }
        this.initLimitlessRouterMonitorService();
        if (isInitialConnection) {
            this.limitlessRouterService.startMonitoring(hostSpec, this.properties, INTERVAL_MILLIS.getInteger(this.properties));
        }
        LimitlessConnectionContext context = new LimitlessConnectionContext(hostSpec, props, conn, connectFunc, null, this);
        this.limitlessRouterService.establishConnection(context);
        if (context.getConnection() != null) {
            return context.getConnection();
        }
        throw new SQLException(Messages.get("LimitlessConnectionPlugin.failedToConnectToHost", new Object[]{hostSpec.getHost()}));
    }

    private void initLimitlessRouterMonitorService() {
        if (this.limitlessRouterService == null) {
            this.limitlessRouterService = this.limitlessRouterServiceSupplier.get();
        }
    }

    static {
        PropertyDefinition.registerPluginProperties(LimitlessConnectionPlugin.class);
    }
}

