/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.failover.ClusterAwareReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.plugin.failover.WriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.WriterFailoverResult;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.ServiceUtility;
import software.amazon.jdbc.util.Utils;

public class ClusterAwareWriterFailoverHandler
implements WriterFailoverHandler {
    private static final Logger LOGGER = Logger.getLogger(ClusterAwareReaderFailoverHandler.class.getName());
    protected static final WriterFailoverResult DEFAULT_RESULT = new WriterFailoverResult(false, false, null, null, "None");
    protected final Properties initialConnectionProps;
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected final ReaderFailoverHandler readerFailoverHandler;
    protected final Map<String, HostAvailability> hostAvailabilityMap = new ConcurrentHashMap<String, HostAvailability>();
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;

    public ClusterAwareWriterFailoverHandler(FullServicesContainer servicesContainer, ReaderFailoverHandler readerFailoverHandler, Properties initialConnectionProps) {
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.readerFailoverHandler = readerFailoverHandler;
        this.initialConnectionProps = initialConnectionProps;
    }

    public ClusterAwareWriterFailoverHandler(FullServicesContainer servicesContainer, ReaderFailoverHandler readerFailoverHandler, Properties initialConnectionProps, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs) {
        this(servicesContainer, readerFailoverHandler, initialConnectionProps);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    @Override
    public Map<String, HostAvailability> getHostAvailabilityMap() {
        return this.hostAvailabilityMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriterFailoverResult failover(List<HostSpec> currentTopology) throws SQLException {
        if (Utils.isNullOrEmpty(currentTopology)) {
            LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.failoverCalledWithInvalidTopology"));
            return DEFAULT_RESULT;
        }
        boolean singleTask = this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.DISABLE_TASK_A);
        ExecutorService executorService = ExecutorFactory.newFixedThreadPool(2, "failover");
        ExecutorCompletionService<WriterFailoverResult> completionService = new ExecutorCompletionService<WriterFailoverResult>(executorService);
        this.submitTasks(currentTopology, executorService, completionService, singleTask);
        try {
            long startTimeNano = System.nanoTime();
            WriterFailoverResult result = this.getNextResult(executorService, completionService, this.maxFailoverTimeoutMs);
            if (result.isConnected() || result.getException() != null || singleTask) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            long endTimeNano = System.nanoTime();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(endTimeNano - startTimeNano);
            long remainingTimeMs = (long)this.maxFailoverTimeoutMs - durationMs;
            if (remainingTimeMs > 0L && ((result = this.getNextResult(executorService, completionService, remainingTimeMs)).isConnected() || result.getException() != null)) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.failedToConnectToWriterInstance"));
            WriterFailoverResult writerFailoverResult = DEFAULT_RESULT;
            return writerFailoverResult;
        }
        finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private void submitTasks(List<HostSpec> currentTopology, ExecutorService executorService, CompletionService<WriterFailoverResult> completionService, boolean singleTask) throws SQLException {
        HostSpec writerHost = Utils.getWriter(currentTopology);
        if (!singleTask) {
            completionService.submit(new ReconnectToWriterHandler(this.newServicesContainer(), this.hostAvailabilityMap, writerHost, this.initialConnectionProps, this.reconnectWriterIntervalMs));
        }
        completionService.submit(new WaitForNewWriterHandler(this.newServicesContainer(), this.hostAvailabilityMap, this.readerFailoverHandler, writerHost, this.initialConnectionProps, this.readTopologyIntervalMs, currentTopology));
        executorService.shutdown();
    }

    protected FullServicesContainer newServicesContainer() throws SQLException {
        return ServiceUtility.getInstance().createMinimalServiceContainer(this.servicesContainer, this.initialConnectionProps);
    }

    private WriterFailoverResult getNextResult(ExecutorService executorService, CompletionService<WriterFailoverResult> completionService, long timeoutMs) throws SQLException {
        try {
            Future<WriterFailoverResult> firstCompleted = completionService.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted == null) {
                return DEFAULT_RESULT;
            }
            WriterFailoverResult result = firstCompleted.get();
            if (result.isConnected()) {
                executorService.shutdownNow();
                this.logTaskSuccess(result);
                return result;
            }
            if (result.getException() != null) {
                executorService.shutdownNow();
                return result;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return DEFAULT_RESULT;
    }

    private void logTaskSuccess(WriterFailoverResult result) {
        String newWriterHost;
        List<HostSpec> topology = result.getTopology();
        if (Utils.isNullOrEmpty(topology)) {
            String taskName = result.getTaskName() == null ? "None" : result.getTaskName();
            LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfulConnectionInvalidTopology", new Object[]{taskName}));
            return;
        }
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        HostSpec writerHost = Utils.getWriter(topology);
        String string = newWriterHost = writerHost == null ? null : writerHost.getUrl();
        if (result.isNewHost()) {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfullyConnectedToNewWriterInstance", new Object[]{newWriterHost}));
        } else {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfullyReconnectedToWriterInstance", new Object[]{newWriterHost}));
        }
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException(Messages.get("ClusterAwareWriterFailoverHandler.interruptedThread"), "70100", e);
    }

    private static class WaitForNewWriterHandler
    implements Callable<WriterFailoverResult> {
        private final PluginService pluginService;
        private final Map<String, HostAvailability> availabilityMap;
        private final ReaderFailoverHandler readerFailoverHandler;
        private final HostSpec originalWriterHost;
        private final Properties props;
        private final int readTopologyIntervalMs;
        private Connection currentConnection = null;
        private List<HostSpec> currentTopology;
        private HostSpec currentReaderHost;
        private Connection currentReaderConnection;

        public WaitForNewWriterHandler(FullServicesContainer servicesContainer, Map<String, HostAvailability> availabilityMap, ReaderFailoverHandler readerFailoverHandler, HostSpec originalWriterHost, Properties props, int readTopologyIntervalMs, List<HostSpec> currentTopology) {
            this.pluginService = servicesContainer.getPluginService();
            this.availabilityMap = availabilityMap;
            this.readerFailoverHandler = readerFailoverHandler;
            this.originalWriterHost = originalWriterHost;
            this.props = props;
            this.readTopologyIntervalMs = readTopologyIntervalMs;
            this.currentTopology = currentTopology;
        }

        @Override
        public WriterFailoverResult call() {
            LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBAttemptConnectionToNewWriterInstance", new Object[]{PropertyUtils.maskProperties(this.props)}));
            try {
                boolean success = false;
                while (!success) {
                    this.connectToReader();
                    success = this.refreshTopologyAndConnectToNewWriter();
                    if (success) continue;
                    this.closeReaderConnection();
                }
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(true, true, this.currentTopology, this.currentConnection, "TaskB");
                return writerFailoverResult;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskB");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBEncounteredException", new Object[]{ex.getMessage()}));
                throw ex;
            }
            finally {
                this.performFinalCleanup();
                LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskBFinished"));
            }
        }

        private void connectToReader() throws InterruptedException {
            while (true) {
                try {
                    ReaderFailoverResult connResult = this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    if (this.isValidReaderConnection(connResult)) {
                        this.currentReaderConnection = connResult.getConnection();
                        this.currentReaderHost = connResult.getHost();
                        LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBConnectedToReader", new Object[]{this.currentReaderHost.getUrl()}));
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBFailedToConnectToAnyReader"));
                TimeUnit.SECONDS.sleep(1L);
            }
        }

        private boolean isValidReaderConnection(ReaderFailoverResult result) {
            return result.isConnected() && result.getConnection() != null && result.getHost() != null;
        }

        private boolean refreshTopologyAndConnectToNewWriter() throws InterruptedException {
            boolean allowOldWriter = this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.ENABLE_WRITER_IN_TASK_B);
            while (true) {
                try {
                    this.pluginService.forceRefreshHostList(this.currentReaderConnection);
                    List<HostSpec> topology = this.pluginService.getAllHosts();
                    if (!topology.isEmpty()) {
                        if (topology.size() == 1) {
                            LOGGER.finest(() -> Messages.get("ClusterAwareWriterFailoverHandler.standaloneNode", new Object[]{this.currentReaderHost.getUrl()}));
                        } else {
                            this.currentTopology = topology;
                            HostSpec writerCandidate = Utils.getWriter(this.currentTopology);
                            if (allowOldWriter || !this.isSame(writerCandidate, this.originalWriterHost)) {
                                LOGGER.finest(() -> Utils.logTopology(this.currentTopology, "[TaskB] Topology:"));
                                if (this.connectToWriter(writerCandidate)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBEncounteredException", new Object[]{e}));
                    return false;
                }
                TimeUnit.MILLISECONDS.sleep(this.readTopologyIntervalMs);
            }
        }

        private boolean isSame(HostSpec hostSpec1, HostSpec hostSpec2) {
            if (hostSpec1 == null || hostSpec2 == null) {
                return false;
            }
            return hostSpec1.getUrl().equals(hostSpec2.getUrl());
        }

        private boolean connectToWriter(HostSpec writerCandidate) {
            if (this.isSame(writerCandidate, this.currentReaderHost)) {
                LOGGER.finest(() -> Messages.get("ClusterAwareWriterFailoverHandler.alreadyWriter"));
                this.currentConnection = this.currentReaderConnection;
                return true;
            }
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBAttemptConnectionToNewWriter", new Object[]{writerCandidate.getUrl()}));
            try {
                this.currentConnection = this.pluginService.forceConnect(writerCandidate, this.props);
                this.availabilityMap.put(writerCandidate.getHost(), HostAvailability.AVAILABLE);
                return true;
            }
            catch (SQLException exception) {
                this.availabilityMap.put(writerCandidate.getHost(), HostAvailability.NOT_AVAILABLE);
                return false;
            }
        }

        private void closeReaderConnection() {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.currentReaderConnection = null;
                this.currentReaderHost = null;
            }
        }

        private void performFinalCleanup() {
            if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                try {
                    this.currentReaderConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private static class ReconnectToWriterHandler
    implements Callable<WriterFailoverResult> {
        private final PluginService pluginService;
        private final Map<String, HostAvailability> availabilityMap;
        private final HostSpec originalWriterHost;
        private final Properties props;
        private final int reconnectWriterIntervalMs;

        public ReconnectToWriterHandler(FullServicesContainer servicesContainer, Map<String, HostAvailability> availabilityMap, HostSpec originalWriterHost, Properties props, int reconnectWriterIntervalMs) {
            this.pluginService = servicesContainer.getPluginService();
            this.availabilityMap = availabilityMap;
            this.originalWriterHost = originalWriterHost;
            this.props = props;
            this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WriterFailoverResult call() {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskAAttemptReconnectToWriterInstance", new Object[]{this.originalWriterHost.getUrl(), PropertyUtils.maskProperties(this.props)}));
            Connection conn = null;
            List<HostSpec> latestTopology = null;
            boolean success = false;
            try {
                while (Utils.isNullOrEmpty(latestTopology)) {
                    block24: {
                        try {
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                            }
                            conn = this.pluginService.forceConnect(this.originalWriterHost, this.props);
                            this.pluginService.forceRefreshHostList(conn);
                            latestTopology = this.pluginService.getAllHosts();
                        }
                        catch (SQLException exception) {
                            if (this.pluginService.isNetworkException(exception, this.pluginService.getTargetDriverDialect())) break block24;
                            LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskAEncounteredException", new Object[]{exception}));
                            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA", exception);
                            try {
                                if (conn != null && !success && !conn.isClosed()) {
                                    conn.close();
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskAFinished"));
                            return writerFailoverResult;
                        }
                    }
                    if (!Utils.isNullOrEmpty(latestTopology)) continue;
                    TimeUnit.MILLISECONDS.sleep(this.reconnectWriterIntervalMs);
                }
                success = this.isCurrentHostWriter(latestTopology);
                LOGGER.finest("[TaskA] success: " + success);
                this.availabilityMap.put(this.originalWriterHost.getHost(), HostAvailability.AVAILABLE);
                WriterFailoverResult exception = new WriterFailoverResult(success, false, latestTopology, success ? conn : null, "TaskA");
                return exception;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(success, false, latestTopology, success ? conn : null, "TaskA");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                LOGGER.severe(ex::getMessage);
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA");
                return writerFailoverResult;
            }
            finally {
                try {
                    if (conn != null && !success && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
                LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskAFinished"));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isCurrentHostWriter(List<HostSpec> latestTopology) {
            HostSpec latestWriter = Utils.getWriter(latestTopology);
            if (latestWriter == null) {
                return false;
            }
            Set<String> latestWriterAllAliases = latestWriter.asAliases();
            Set<String> currentAliases = this.originalWriterHost.asAliases();
            if (currentAliases == null) return false;
            if (!latestWriterAllAliases.stream().anyMatch(currentAliases::contains)) return false;
            return true;
        }
    }
}

