/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.HostMonitor;
import software.amazon.jdbc.plugin.efm.HostMonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.HostMonitorThreadContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class HostMonitorImpl
implements HostMonitor {
    private static final Logger LOGGER = Logger.getLogger(HostMonitorImpl.class.getName());
    private static final long THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100L;
    private static final long MIN_CONNECTION_CHECK_TIMEOUT_MILLIS = 100L;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    final Queue<HostMonitorConnectionContext> activeContexts = new ConcurrentLinkedQueue<HostMonitorConnectionContext>();
    private final Queue<HostMonitorConnectionContext> newContexts = new ConcurrentLinkedQueue<HostMonitorConnectionContext>();
    private final PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private final Properties properties;
    private final HostSpec hostSpec;
    private final HostMonitorThreadContainer threadContainer;
    private final long monitorDisposalTimeMillis;
    private volatile long contextLastUsedTimestampNano;
    private volatile boolean stopped = false;
    private final AtomicReference<Connection> monitoringConn = new AtomicReference<Object>(null);
    private long nodeCheckTimeoutMillis = 100L;
    private final TelemetryGauge contextsSizeGauge;
    private final TelemetryCounter nodeInvalidCounter;

    public HostMonitorImpl(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties properties, long monitorDisposalTimeMillis, @NonNull HostMonitorThreadContainer threadContainer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.hostSpec = hostSpec;
        this.properties = properties;
        this.monitorDisposalTimeMillis = monitorDisposalTimeMillis;
        this.threadContainer = threadContainer;
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
        this.contextsSizeGauge = this.telemetryFactory.createGauge("efm.activeContexts.queue.size", () -> this.activeContexts.size());
        String nodeId = StringUtils.isNullOrEmpty(this.hostSpec.getHostId()) ? this.hostSpec.getHost() : this.hostSpec.getHostId();
        this.nodeInvalidCounter = this.telemetryFactory.createCounter(String.format("efm.nodeUnhealthy.count.%s", nodeId));
    }

    @Override
    public void startMonitoring(HostMonitorConnectionContext context) {
        if (this.stopped) {
            LOGGER.warning(() -> Messages.get("HostMonitorImpl.monitorIsStopped", new Object[]{this.hostSpec.getHost()}));
        }
        long currentTimeNano = this.getCurrentTimeNano();
        context.setStartMonitorTimeNano(currentTimeNano);
        this.contextLastUsedTimestampNano = currentTimeNano;
        this.newContexts.add(context);
    }

    @Override
    public void stopMonitoring(HostMonitorConnectionContext context) {
        if (context == null) {
            LOGGER.warning(() -> Messages.get("HostMonitorImpl.contextNullWarning"));
            return;
        }
        context.setInactive();
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
    }

    @Override
    public void clearContexts() {
        this.newContexts.clear();
        this.activeContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block29: {
            LOGGER.finest(() -> Messages.get("HostMonitorImpl.startMonitoringThread", new Object[]{this.hostSpec.getHost()}));
            try {
                this.stopped = false;
                while (true) {
                    try {
                        while (true) {
                            HostMonitorConnectionContext newMonitorContext;
                            HostMonitorConnectionContext firstAddedNewMonitorContext = null;
                            long currentTimeNano = this.getCurrentTimeNano();
                            while ((newMonitorContext = this.newContexts.poll()) != null) {
                                if (firstAddedNewMonitorContext == newMonitorContext) {
                                    this.newContexts.add(newMonitorContext);
                                    break;
                                }
                                if (!newMonitorContext.isActiveContext()) continue;
                                if (newMonitorContext.getExpectedActiveMonitoringStartTimeNano() > currentTimeNano) {
                                    this.newContexts.add(newMonitorContext);
                                    if (firstAddedNewMonitorContext != null) continue;
                                    firstAddedNewMonitorContext = newMonitorContext;
                                    continue;
                                }
                                this.activeContexts.add(newMonitorContext);
                            }
                            Connection copyConnection = this.monitoringConn.get();
                            if (!this.activeContexts.isEmpty() || copyConnection == null || copyConnection.isClosed()) {
                                HostMonitorConnectionContext monitorContext;
                                long statusCheckStartTimeNano;
                                this.contextLastUsedTimestampNano = statusCheckStartTimeNano = this.getCurrentTimeNano();
                                ConnectionStatus status = this.checkConnectionStatus(this.nodeCheckTimeoutMillis);
                                long delayMillis = -1L;
                                HostMonitorConnectionContext firstAddedMonitorContext = null;
                                while ((monitorContext = this.activeContexts.poll()) != null) {
                                    monitorContext.getLock().lock();
                                    try {
                                        if (!monitorContext.isActiveContext()) continue;
                                        if (firstAddedMonitorContext == monitorContext) {
                                            this.activeContexts.add(monitorContext);
                                            break;
                                        }
                                        monitorContext.updateConnectionStatus(this.hostSpec.getUrl(), statusCheckStartTimeNano, statusCheckStartTimeNano + status.elapsedTimeNano, status.isValid);
                                        if (!monitorContext.isActiveContext() || monitorContext.isNodeUnhealthy()) continue;
                                        this.activeContexts.add(monitorContext);
                                        if (firstAddedMonitorContext == null) {
                                            firstAddedMonitorContext = monitorContext;
                                        }
                                        if (delayMillis != -1L && delayMillis <= monitorContext.getFailureDetectionIntervalMillis()) continue;
                                        delayMillis = monitorContext.getFailureDetectionIntervalMillis();
                                    }
                                    finally {
                                        monitorContext.getLock().unlock();
                                    }
                                }
                                if (delayMillis == -1L) {
                                    delayMillis = 100L;
                                } else {
                                    if ((delayMillis -= TimeUnit.NANOSECONDS.toMillis(status.elapsedTimeNano)) <= 100L) {
                                        delayMillis = 100L;
                                    }
                                    this.nodeCheckTimeoutMillis = delayMillis;
                                }
                                this.sleep(delayMillis);
                                continue;
                            }
                            if (this.getCurrentTimeNano() - this.contextLastUsedTimestampNano >= TimeUnit.MILLISECONDS.toNanos(this.monitorDisposalTimeMillis)) {
                                this.threadContainer.releaseResource(this);
                                break block29;
                            }
                            this.sleep(100L);
                        }
                    }
                    catch (InterruptedException intEx) {
                        throw intEx;
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, Messages.get("HostMonitorImpl.exceptionDuringMonitoringContinue", new Object[]{this.hostSpec.getHost()}), ex);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException intEx) {
                LOGGER.warning(() -> Messages.get("HostMonitorImpl.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, Messages.get("HostMonitorImpl.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
                }
            }
            finally {
                this.threadContainer.releaseResource(this);
                this.stopped = true;
                this.closeConnection();
            }
        }
        LOGGER.finest(() -> Messages.get("HostMonitorImpl.stopMonitoringThread", new Object[]{this.hostSpec.getHost()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionStatus checkConnectionStatus(long shortestFailureDetectionIntervalMillis) {
        TelemetryContext connectContext = this.telemetryFactory.openTelemetryContext("connection status check", TelemetryTraceLevel.FORCE_TOP_LEVEL);
        if (connectContext != null) {
            connectContext.setAttribute("url", this.hostSpec.getHost());
        }
        long startNano = this.getCurrentTimeNano();
        try {
            boolean isValid;
            Connection copyConnection = this.monitoringConn.get();
            if (copyConnection == null || copyConnection.isClosed()) {
                Properties monitoringConnProperties = PropertyUtils.copyProperties(this.properties);
                this.properties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
                    monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.properties.getProperty((String)p));
                    monitoringConnProperties.remove(p);
                });
                LOGGER.finest(() -> "Opening a monitoring connection to " + this.hostSpec.getUrl());
                startNano = this.getCurrentTimeNano();
                this.monitoringConn.set(this.pluginService.forceConnect(this.hostSpec, monitoringConnProperties));
                LOGGER.finest(() -> "Opened monitoring connection: " + this.monitoringConn.get());
                ConnectionStatus connectionStatus = new ConnectionStatus(true, this.getCurrentTimeNano() - startNano);
                return connectionStatus;
            }
            startNano = this.getCurrentTimeNano();
            Connection copyConnection2 = this.monitoringConn.get();
            boolean bl = isValid = copyConnection2 != null && copyConnection2.isValid((int)TimeUnit.MILLISECONDS.toSeconds(shortestFailureDetectionIntervalMillis) / 2);
            if (!isValid && this.nodeInvalidCounter != null) {
                this.nodeInvalidCounter.inc();
            }
            ConnectionStatus connectionStatus = new ConnectionStatus(isValid, this.getCurrentTimeNano() - startNano);
            return connectionStatus;
        }
        catch (SQLException sqlEx) {
            if (this.nodeInvalidCounter != null) {
                this.nodeInvalidCounter.inc();
            }
            ConnectionStatus connectionStatus = new ConnectionStatus(false, this.getCurrentTimeNano() - startNano);
            return connectionStatus;
        }
        finally {
            if (connectContext != null) {
                connectContext.closeContext();
            }
        }
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    protected void sleep(long duration) throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(duration);
    }

    protected void closeConnection() {
        Connection conn = this.monitoringConn.getAndSet(null);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void reset() {
        LOGGER.finest("Reset: " + this.hostSpec.getHost());
        this.closeConnection();
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTimeNano;

        ConnectionStatus(boolean isValid, long elapsedTimeNano) {
            this.isValid = isValid;
            this.elapsedTimeNano = elapsedTimeNano;
        }
    }
}

