/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.util.concurrent.TimeUnit;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.util.storage.StorageService;

public abstract class BaseRouting {
    protected static final long SLEEP_CHUNK = 50L;

    protected long getNanoTime() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(long delayMs, BlueGreenStatus bgStatus, StorageService storageService, String bgdId) throws InterruptedException {
        long start = System.nanoTime();
        long end = start + TimeUnit.MILLISECONDS.toNanos(delayMs);
        long minDelay = Math.min(delayMs, 50L);
        if (bgStatus == null) {
            TimeUnit.MILLISECONDS.sleep(delayMs);
        } else {
            do {
                BlueGreenStatus blueGreenStatus = bgStatus;
                synchronized (blueGreenStatus) {
                    bgStatus.wait(minDelay);
                }
            } while (bgStatus == storageService.get(BlueGreenStatus.class, bgdId) && System.nanoTime() < end && !Thread.currentThread().isInterrupted());
        }
    }
}

