/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenProviderSupplier;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatusProvider;
import software.amazon.jdbc.plugin.bluegreen.routing.ConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.ExecuteRouting;
import software.amazon.jdbc.plugin.iam.IamAuthConnectionPlugin;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class BlueGreenConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(BlueGreenConnectionPlugin.class.getName());
    public static final AwsWrapperProperty BG_CONNECT_TIMEOUT = new AwsWrapperProperty("bgConnectTimeoutMs", "30000", "Connect timeout (in msec) during Blue/Green Deployment switchover.");
    public static final AwsWrapperProperty BGD_ID = new AwsWrapperProperty("bgdId", "1", "Blue/Green Deployment identifier that helps the driver to distinguish different deployments.");
    protected static Map<String, BlueGreenStatusProvider> provider = new ConcurrentHashMap<String, BlueGreenStatusProvider>();
    private static final Set<String> CLOSING_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JdbcMethod.CONNECTION_CLOSE.methodName, JdbcMethod.CONNECTION_ABORT.methodName, JdbcMethod.STATEMENT_CLOSE.methodName, JdbcMethod.CALLABLESTATEMENT_CLOSE.methodName, JdbcMethod.PREPAREDSTATEMENT_CLOSE.methodName, JdbcMethod.RESULTSET_CLOSE.methodName)));
    protected static final String BG_SKIP_ROUTING_IN_FORCE_CONNECT = "3a864d24-568f-4b55-a227-6f649ae3021a";
    protected final FullServicesContainer servicesContainer;
    protected final StorageService storageService;
    protected final PluginService pluginService;
    protected final Properties props;
    protected BlueGreenProviderSupplier providerSupplier;
    protected final TelemetryFactory telemetryFactory;
    protected final RdsUtils rdsUtils = new RdsUtils();
    protected BlueGreenStatus bgStatus = null;
    protected String bgdId;
    protected String clusterId;
    protected boolean isIamInUse = false;
    protected final AtomicLong startTimeNano = new AtomicLong(0L);
    protected final AtomicLong endTimeNano = new AtomicLong(0L);
    protected final Set<String> subscribedMethods;

    public BlueGreenConnectionPlugin(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props) {
        this(servicesContainer, props, BlueGreenStatusProvider::new);
    }

    public BlueGreenConnectionPlugin(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props, @NonNull BlueGreenProviderSupplier providerSupplier) {
        this.servicesContainer = servicesContainer;
        this.storageService = servicesContainer.getStorageService();
        this.pluginService = servicesContainer.getPluginService();
        this.props = props;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        this.providerSupplier = providerSupplier;
        this.bgdId = Objects.requireNonNull(BGD_ID.getString(this.props)).trim().toLowerCase();
        HashSet<String> methods = new HashSet<String>();
        methods.add(JdbcMethod.CONNECT.methodName);
        methods.add(JdbcMethod.FORCECONNECT.methodName);
        methods.addAll(this.pluginService.getTargetDriverDialect().getNetworkBoundMethodNames(this.props));
        this.subscribedMethods = Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return this.subscribedMethods;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        if (props.containsKey(BG_SKIP_ROUTING_IN_FORCE_CONNECT)) {
            return connectFunc.call();
        }
        return this.connectInternal(hostSpec, props, isInitialConnection, true, connectFunc);
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(hostSpec, props, isInitialConnection, false, connectFunc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection connectInternal(HostSpec hostSpec, Properties props, boolean isInitialConnection, boolean useForceConnect, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        this.resetRoutingTimeNano();
        try {
            BlueGreenRole hostRole;
            this.bgStatus = this.storageService.get(BlueGreenStatus.class, this.bgdId);
            if (this.bgStatus == null) {
                Connection connection = this.regularOpenConnection(connectFunc, isInitialConnection, useForceConnect);
                return connection;
            }
            if (isInitialConnection) {
                this.isIamInUse = this.pluginService.isPluginInUse(IamAuthConnectionPlugin.class);
            }
            if ((hostRole = this.bgStatus.getRole(hostSpec)) == null) {
                Connection connection = this.regularOpenConnection(connectFunc, isInitialConnection, useForceConnect);
                return connection;
            }
            Connection conn = null;
            ConnectRouting routing = this.bgStatus.getConnectRouting().stream().filter(r -> r.isMatch(hostSpec, hostRole)).findFirst().orElse(null);
            if (routing == null) {
                Connection connection = this.regularOpenConnection(connectFunc, isInitialConnection, useForceConnect);
                return connection;
            }
            this.startTimeNano.set(this.getNanoTime());
            while (routing != null && conn == null) {
                conn = routing.apply(this, hostSpec, props, isInitialConnection, useForceConnect, connectFunc, this.storageService, this.pluginService);
                if (conn != null) continue;
                this.bgStatus = this.storageService.get(BlueGreenStatus.class, this.bgdId);
                if (this.bgStatus == null) {
                    this.endTimeNano.set(this.getNanoTime());
                    Connection connection = this.regularOpenConnection(connectFunc, isInitialConnection, useForceConnect);
                    return connection;
                }
                routing = this.bgStatus.getConnectRouting().stream().filter(r -> r.isMatch(hostSpec, hostRole)).findFirst().orElse(null);
            }
            this.endTimeNano.set(this.getNanoTime());
            if (conn == null) {
                conn = connectFunc.call();
            }
            if (isInitialConnection && !useForceConnect) {
                this.initProvider();
            }
            Connection connection = conn;
            return connection;
        }
        finally {
            if (this.startTimeNano.get() > 0L) {
                this.endTimeNano.compareAndSet(0L, this.getNanoTime());
            }
        }
    }

    protected Connection regularOpenConnection(JdbcCallable<Connection, SQLException> connectFunc, boolean isInitialConnection, boolean useForceConnect) throws SQLException {
        Connection conn = connectFunc.call();
        if (isInitialConnection && !useForceConnect) {
            this.initProvider();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        this.resetRoutingTimeNano();
        try {
            this.initProvider();
            if (CLOSING_METHOD_NAMES.contains(methodName)) {
                T t = jdbcMethodFunc.call();
                return t;
            }
            this.bgStatus = this.storageService.get(BlueGreenStatus.class, this.bgdId);
            if (this.bgStatus == null) {
                T t = jdbcMethodFunc.call();
                return t;
            }
            HostSpec currentHostSpec = this.pluginService.getCurrentHostSpec();
            BlueGreenRole hostRole = this.bgStatus.getRole(currentHostSpec);
            if (hostRole == null) {
                T t = jdbcMethodFunc.call();
                return t;
            }
            Optional result = Optional.empty();
            ExecuteRouting routing = this.bgStatus.getExecuteRouting().stream().filter(r -> r.isMatch(currentHostSpec, hostRole)).findFirst().orElse(null);
            if (routing == null) {
                T t = jdbcMethodFunc.call();
                return t;
            }
            this.startTimeNano.set(this.getNanoTime());
            while (routing != null && !result.isPresent()) {
                result = routing.apply(this, resultClass, exceptionClass, methodInvokeOn, methodName, jdbcMethodFunc, jdbcMethodArgs, this.storageService, this.pluginService, this.props);
                if (result.isPresent()) continue;
                this.bgStatus = this.storageService.get(BlueGreenStatus.class, this.bgdId);
                if (this.bgStatus == null) {
                    this.endTimeNano.set(this.getNanoTime());
                    T t = jdbcMethodFunc.call();
                    return t;
                }
                routing = this.bgStatus.getExecuteRouting().stream().filter(r -> r.isMatch(currentHostSpec, hostRole)).findFirst().orElse(null);
            }
            this.endTimeNano.set(this.getNanoTime());
            if (result.isPresent()) {
                Object t = result.get();
                return t;
            }
            T t = jdbcMethodFunc.call();
            return t;
        }
        finally {
            if (this.startTimeNano.get() > 0L) {
                this.endTimeNano.compareAndSet(0L, this.getNanoTime());
            }
        }
    }

    protected void initProvider() {
        try {
            this.clusterId = this.pluginService.getHostListProvider().getClusterId();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        provider.computeIfAbsent(this.bgdId, key -> this.providerSupplier.create(this.servicesContainer, this.props, this.bgdId, this.clusterId));
    }

    protected long getNanoTime() {
        return System.nanoTime();
    }

    public long getHoldTimeNano() {
        return this.startTimeNano.get() == 0L ? 0L : (this.endTimeNano.get() == 0L ? this.getNanoTime() - this.startTimeNano.get() : this.endTimeNano.get() - this.startTimeNano.get());
    }

    public void resetRoutingTimeNano() {
        this.startTimeNano.set(0L);
        this.endTimeNano.set(0L);
    }

    static {
        PropertyDefinition.registerPluginProperties(BlueGreenConnectionPlugin.class);
    }
}

