/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.WrapperUtils;

public class AuroraInitialConnectionStrategyPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(AuroraInitialConnectionStrategyPlugin.class.getName());
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("initHostProvider");
            this.add("connect");
        }
    });
    public static final AwsWrapperProperty READER_HOST_SELECTOR_STRATEGY = new AwsWrapperProperty("readerInitialConnectionHostSelectorStrategy", "random", "The strategy that should be used to select a new reader host while opening a new connection.");
    public static final AwsWrapperProperty OPEN_CONNECTION_RETRY_TIMEOUT_MS = new AwsWrapperProperty("openConnectionRetryTimeoutMs", "30000", "Maximum allowed time for the retries opening a connection.");
    public static final AwsWrapperProperty OPEN_CONNECTION_RETRY_INTERVAL_MS = new AwsWrapperProperty("openConnectionRetryIntervalMs", "1000", "Time between each retry of opening a connection.");
    public static final AwsWrapperProperty VERIFY_OPENED_CONNECTION_TYPE = new AwsWrapperProperty("verifyOpenedConnectionType", null, "Force to verify an opened connection to be either a writer or a reader.");
    private final PluginService pluginService;
    private HostListProviderService hostListProviderService;
    private final RdsUtils rdsUtils = new RdsUtils();
    private VerifyOpenedConnectionType verifyOpenedConnectionType = null;

    public AuroraInitialConnectionStrategyPlugin(PluginService pluginService, Properties properties) {
        this.pluginService = pluginService;
        this.verifyOpenedConnectionType = VerifyOpenedConnectionType.fromValue(VERIFY_OPENED_CONNECTION_TYPE.getString(properties));
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.hostListProviderService = hostListProviderService;
        if (hostListProviderService.isStaticHostListProvider()) {
            throw new SQLException(Messages.get("AuroraInitialConnectionStrategyPlugin.requireDynamicProvider"));
        }
        initHostProviderFunc.call();
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        RdsUrlType type = this.rdsUtils.identifyRdsType(hostSpec.getHost());
        if (type == RdsUrlType.RDS_WRITER_CLUSTER || isInitialConnection && this.verifyOpenedConnectionType == VerifyOpenedConnectionType.WRITER) {
            Connection writerCandidateConn = this.getVerifiedWriterConnection(props, isInitialConnection, connectFunc);
            if (writerCandidateConn == null) {
                return connectFunc.call();
            }
            return writerCandidateConn;
        }
        if (type == RdsUrlType.RDS_READER_CLUSTER || isInitialConnection && this.verifyOpenedConnectionType == VerifyOpenedConnectionType.READER) {
            Connection readerCandidateConn = this.getVerifiedReaderConnection(props, isInitialConnection, connectFunc);
            if (readerCandidateConn == null) {
                LOGGER.finest("Continue with normal workflow.");
                return connectFunc.call();
            }
            return readerCandidateConn;
        }
        return connectFunc.call();
    }

    private Connection getVerifiedWriterConnection(Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        int retryDelayMs = OPEN_CONNECTION_RETRY_INTERVAL_MS.getInteger(props);
        long endTimeNano = this.getTime() + TimeUnit.MILLISECONDS.toNanos(OPEN_CONNECTION_RETRY_TIMEOUT_MS.getInteger(props));
        while (this.getTime() < endTimeNano) {
            Connection writerCandidateConn = null;
            HostSpec writerCandidate = null;
            try {
                writerCandidate = Utils.getWriter(this.pluginService.getAllHosts());
                if (writerCandidate == null || this.rdsUtils.isRdsClusterDns(writerCandidate.getHost())) {
                    writerCandidateConn = connectFunc.call();
                    this.pluginService.forceRefreshHostList(writerCandidateConn);
                    writerCandidate = this.pluginService.identifyConnection(writerCandidateConn);
                    if (writerCandidate == null || writerCandidate.getRole() != HostRole.WRITER) {
                        this.closeConnection(writerCandidateConn);
                        this.delay(retryDelayMs);
                        continue;
                    }
                    if (isInitialConnection) {
                        this.hostListProviderService.setInitialConnectionHostSpec(writerCandidate);
                    }
                    return writerCandidateConn;
                }
                writerCandidateConn = this.pluginService.connect(writerCandidate, props, this);
                if (this.pluginService.getHostRole(writerCandidateConn) != HostRole.WRITER) {
                    this.pluginService.forceRefreshHostList(writerCandidateConn);
                    this.closeConnection(writerCandidateConn);
                    this.delay(retryDelayMs);
                    continue;
                }
                if (isInitialConnection) {
                    this.hostListProviderService.setInitialConnectionHostSpec(writerCandidate);
                }
                return writerCandidateConn;
            }
            catch (SQLException ex) {
                this.closeConnection(writerCandidateConn);
                if (this.pluginService.isLoginException(ex, this.pluginService.getTargetDriverDialect())) {
                    throw WrapperUtils.wrapExceptionIfNeeded(SQLException.class, ex);
                }
                if (writerCandidate != null) {
                    this.pluginService.setAvailability(writerCandidate.asAliases(), HostAvailability.NOT_AVAILABLE);
                }
                throw ex;
            }
            catch (Throwable ex) {
                this.closeConnection(writerCandidateConn);
                throw ex;
            }
        }
        return null;
    }

    private Connection getVerifiedReaderConnection(Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        int retryDelayMs = OPEN_CONNECTION_RETRY_INTERVAL_MS.getInteger(props);
        long endTimeNano = this.getTime() + TimeUnit.MILLISECONDS.toNanos(OPEN_CONNECTION_RETRY_TIMEOUT_MS.getInteger(props));
        while (this.getTime() < endTimeNano) {
            Connection readerCandidateConn = null;
            HostSpec readerCandidate = null;
            try {
                readerCandidate = this.getReader(props);
                if (readerCandidate == null || this.rdsUtils.isRdsClusterDns(readerCandidate.getHost())) {
                    readerCandidateConn = connectFunc.call();
                    this.pluginService.forceRefreshHostList(readerCandidateConn);
                    readerCandidate = this.pluginService.identifyConnection(readerCandidateConn);
                    if (readerCandidate == null) {
                        this.closeConnection(readerCandidateConn);
                        this.delay(retryDelayMs);
                        continue;
                    }
                    if (readerCandidate.getRole() != HostRole.READER) {
                        if (this.hasNoReaders()) {
                            if (isInitialConnection) {
                                this.hostListProviderService.setInitialConnectionHostSpec(readerCandidate);
                            }
                            return readerCandidateConn;
                        }
                        this.closeConnection(readerCandidateConn);
                        this.delay(retryDelayMs);
                        continue;
                    }
                    if (isInitialConnection) {
                        this.hostListProviderService.setInitialConnectionHostSpec(readerCandidate);
                    }
                    return readerCandidateConn;
                }
                readerCandidateConn = this.pluginService.connect(readerCandidate, props, this);
                if (this.pluginService.getHostRole(readerCandidateConn) != HostRole.READER) {
                    this.pluginService.forceRefreshHostList(readerCandidateConn);
                    if (this.hasNoReaders()) {
                        if (isInitialConnection) {
                            this.hostListProviderService.setInitialConnectionHostSpec(readerCandidate);
                        }
                        return readerCandidateConn;
                    }
                    this.closeConnection(readerCandidateConn);
                    this.delay(retryDelayMs);
                    continue;
                }
                if (isInitialConnection) {
                    this.hostListProviderService.setInitialConnectionHostSpec(readerCandidate);
                }
                return readerCandidateConn;
            }
            catch (SQLException ex) {
                this.closeConnection(readerCandidateConn);
                if (this.pluginService.isLoginException(ex, this.pluginService.getTargetDriverDialect())) {
                    throw WrapperUtils.wrapExceptionIfNeeded(SQLException.class, ex);
                }
                if (readerCandidate == null) continue;
                this.pluginService.setAvailability(readerCandidate.asAliases(), HostAvailability.NOT_AVAILABLE);
            }
            catch (Throwable ex) {
                this.closeConnection(readerCandidateConn);
                throw ex;
            }
        }
        return null;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void delay(long delayMs) {
        try {
            TimeUnit.MILLISECONDS.sleep(delayMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private HostSpec getReader(Properties props) throws SQLException {
        String strategy = READER_HOST_SELECTOR_STRATEGY.getString(props);
        if (this.pluginService.acceptsStrategy(HostRole.READER, strategy)) {
            try {
                return this.pluginService.getHostSpecByStrategy(HostRole.READER, strategy);
            }
            catch (UnsupportedOperationException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                return null;
            }
        }
        throw new UnsupportedOperationException(Messages.get("AuroraInitialConnectionStrategyPlugin.unsupportedStrategy", new Object[]{strategy}));
    }

    private boolean hasNoReaders() {
        if (this.pluginService.getAllHosts().isEmpty()) {
            return false;
        }
        for (HostSpec hostSpec : this.pluginService.getAllHosts()) {
            if (hostSpec.getRole() == HostRole.WRITER) continue;
            return false;
        }
        return true;
    }

    protected long getTime() {
        return System.nanoTime();
    }

    static {
        PropertyDefinition.registerPluginProperties(AuroraInitialConnectionStrategyPlugin.class);
    }

    private static enum VerifyOpenedConnectionType {
        WRITER,
        READER;

        private static final Map<String, VerifyOpenedConnectionType> nameToValue;

        public static VerifyOpenedConnectionType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return nameToValue.get(value.toLowerCase());
        }

        static {
            nameToValue = new HashMap<String, VerifyOpenedConnectionType>(){
                {
                    this.put("writer", WRITER);
                    this.put("reader", READER);
                }
            };
        }
    }
}

