/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;

public class RdsMultiAzDbClusterListProvider
extends RdsHostListProvider {
    private final String fetchWriterNodeQuery;
    private final String fetchWriterNodeQueryHeader;
    static final Logger LOGGER = Logger.getLogger(RdsMultiAzDbClusterListProvider.class.getName());

    public RdsMultiAzDbClusterListProvider(Properties properties, String originalUrl, FullServicesContainer servicesContainer, String topologyQuery, String nodeIdQuery, String isReaderQuery, String fetchWriterNodeQuery, String fetchWriterNodeQueryHeader) {
        super(properties, originalUrl, servicesContainer, topologyQuery, nodeIdQuery, isReaderQuery);
        this.fetchWriterNodeQuery = fetchWriterNodeQuery;
        this.fetchWriterNodeQueryHeader = fetchWriterNodeQueryHeader;
    }

    @Override
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        int networkTimeout = -1;
        try {
            networkTimeout = conn.getNetworkTimeout();
            if (networkTimeout == 0) {
                conn.setNetworkTimeout(networkTimeoutExecutor, 5000);
            }
        }
        catch (SQLException e) {
            LOGGER.warning(() -> Messages.get("RdsHostListProvider.errorGettingNetworkTimeout", new Object[]{e.getMessage()}));
        }
        try {
            Statement stmt = conn.createStatement();
            String writerNodeId = this.processWriterNodeId(stmt.executeQuery(this.fetchWriterNodeQuery));
            if (writerNodeId == null) {
                ResultSet nodeIdResultSet = stmt.executeQuery(this.nodeIdQuery);
                while (nodeIdResultSet.next()) {
                    writerNodeId = nodeIdResultSet.getString(1);
                }
            }
            ResultSet topologyResultSet = stmt.executeQuery(this.topologyQuery);
            List<HostSpec> list = this.processTopologyQueryResults(topologyResultSet, writerNodeId);
            return list;
        }
        catch (SQLSyntaxErrorException e) {
            throw new SQLException(Messages.get("RdsHostListProvider.invalidQuery"), e);
        }
        finally {
            if (networkTimeout == 0 && !conn.isClosed()) {
                conn.setNetworkTimeout(networkTimeoutExecutor, networkTimeout);
            }
        }
    }

    private String processWriterNodeId(ResultSet fetchWriterNodeResultSet) throws SQLException {
        String writerNodeId = null;
        if (fetchWriterNodeResultSet.next()) {
            writerNodeId = fetchWriterNodeResultSet.getString(this.fetchWriterNodeQueryHeader);
        }
        return writerNodeId;
    }

    private List<HostSpec> processTopologyQueryResults(ResultSet topologyResultSet, String writerNodeId) throws SQLException {
        HashMap<String, HostSpec> hostMap = new HashMap<String, HostSpec>();
        while (topologyResultSet.next()) {
            HostSpec host = this.createHost(topologyResultSet, writerNodeId);
            hostMap.put(host.getHost(), host);
        }
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        ArrayList<HostSpec> writers = new ArrayList<HostSpec>();
        for (HostSpec host : hostMap.values()) {
            if (host.getRole() != HostRole.WRITER) {
                hosts.add(host);
                continue;
            }
            writers.add(host);
        }
        int writerCount = writers.size();
        if (writerCount == 0) {
            LOGGER.severe(() -> Messages.get("RdsHostListProvider.invalidTopology"));
            hosts.clear();
        } else {
            hosts.add((HostSpec)writers.get(0));
        }
        return hosts;
    }

    private HostSpec createHost(ResultSet resultSet, String writerNodeId) throws SQLException {
        String hostName = resultSet.getString("endpoint");
        String instanceName = hostName.substring(0, hostName.indexOf("."));
        String endpoint = this.getHostEndpoint(instanceName);
        String hostId = resultSet.getString("id");
        int queryPort = resultSet.getInt("port");
        int port = this.clusterInstanceTemplate.isPortSpecified() ? this.clusterInstanceTemplate.getPort() : queryPort;
        boolean isWriter = hostId.equals(writerNodeId);
        HostSpec hostSpec = this.hostListProviderService.getHostSpecBuilder().host(endpoint).hostId(hostId).port(port).role(isWriter ? HostRole.WRITER : HostRole.READER).availability(HostAvailability.AVAILABLE).weight(0L).lastUpdateTime(Timestamp.from(Instant.now())).build();
        hostSpec.addAlias(hostName);
        return hostSpec;
    }

    @Override
    protected String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }
}

