/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.PgExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;

public class PgDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-pg", "rds-multi-az-pg-cluster", "rds-pg");
    private static PgExceptionHandler pgExceptionHandler;
    private static final EnumSet<FailoverRestriction> NO_RESTRICTIONS;

    @Override
    public int getDefaultPort() {
        return 5432;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (pgExceptionHandler == null) {
            pgExceptionHandler = new PgExceptionHandler();
        }
        return pgExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT pg_catalog.CONCAT(pg_catalog.inet_server_addr(), ':', pg_catalog.inet_server_port())";
    }

    @Override
    public String getServerVersionQuery() {
        return "SELECT 'version', pg_catalog.VERSION()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT 1 FROM pg_catalog.pg_proc LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, servicesContainer) -> new ConnectionStringHostListProvider(properties, initialUrl, servicesContainer.getHostListProviderService());
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
    }

    @Override
    public EnumSet<FailoverRestriction> getFailoverRestrictions() {
        return NO_RESTRICTIONS;
    }

    static {
        NO_RESTRICTIONS = EnumSet.noneOf(FailoverRestriction.class);
    }
}

