/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.ConnectionProviderManager;
import software.amazon.jdbc.DriverConnectionProvider;
import software.amazon.jdbc.HikariPoolsHolder;
import software.amazon.jdbc.PluginServiceImpl;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.TargetDriverHelper;
import software.amazon.jdbc.authentication.AwsCredentialsManager;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.DialectManager;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.MonitoringRdsHostListProvider;
import software.amazon.jdbc.plugin.AwsSecretsManagerCacheHolder;
import software.amazon.jdbc.plugin.DataCacheConnectionPlugin;
import software.amazon.jdbc.plugin.OpenedConnectionTracker;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointMonitorImpl;
import software.amazon.jdbc.plugin.efm.HostMonitorThreadContainer;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthCacheHolder;
import software.amazon.jdbc.plugin.federatedauth.OktaAuthCacheHolder;
import software.amazon.jdbc.plugin.iam.IamAuthCacheHolder;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterServiceImpl;
import software.amazon.jdbc.plugin.strategy.fastestresponse.FastestResponseStrategyPlugin;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.profile.DriverConfigurationProfiles;
import software.amazon.jdbc.states.ResetSessionStateOnCloseCallable;
import software.amazon.jdbc.states.TransferSessionStateOnSwitchCallable;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectManager;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.CoreServicesContainer;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.ServiceUtility;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.events.EventPublisher;
import software.amazon.jdbc.util.monitoring.MonitorService;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.DefaultTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class Driver
implements java.sql.Driver {
    private static final String PROTOCOL_PREFIX = "jdbc:aws-wrapper:";
    private static final Logger PARENT_LOGGER = Logger.getLogger("software.amazon.jdbc");
    private static final Logger LOGGER = Logger.getLogger("software.amazon.jdbc.Driver");
    private static @Nullable Driver registeredDriver;
    private static final AtomicReference<ResetSessionStateOnCloseCallable> resetSessionStateOnCloseCallable;
    private static final AtomicReference<TransferSessionStateOnSwitchCallable> transferSessionStateOnSwitchCallable;
    private static final AtomicReference<ExceptionHandler> customExceptionHandler;
    private static final AtomicReference<Dialect> customDialect;
    private static final AtomicReference<TargetDriverDialect> customTargetDriverDialect;
    private static final AtomicReference<ConnectionProvider> customConnectionProvider;
    private static final AtomicReference<ConnectionProviderManager.ConnectionInitFunc> connectionInitFunc;
    private final StorageService storageService;
    private final MonitorService monitorService;
    private final EventPublisher eventPublisher;
    private final ConnectionUrlParser urlParser = new ConnectionUrlParser();

    public Driver() {
        this(CoreServicesContainer.getInstance());
    }

    public Driver(CoreServicesContainer coreServicesContainer) {
        this.storageService = coreServicesContainer.getStorageService();
        this.monitorService = coreServicesContainer.getMonitorService();
        this.eventPublisher = coreServicesContainer.getEventPublisher();
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException(Messages.get("Driver.alreadyRegistered"));
        }
        Driver driver = new Driver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException(Messages.get("Driver.notRegistered"));
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        if (registeredDriver != null) {
            ArrayList<java.sql.Driver> registeredDrivers = Collections.list(DriverManager.getDrivers());
            for (java.sql.Driver d : registeredDrivers) {
                if (d != registeredDriver) continue;
                return true;
            }
            registeredDriver = null;
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        LOGGER.finest("Opening connection to " + url);
        ConnectionUrlParser.parsePropertiesFromUrl(url, info);
        Properties props = PropertyUtils.copyProperties(info);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(props, databaseName);
        }
        LOGGER.finest(() -> PropertyUtils.logProperties(PropertyUtils.maskProperties(props), "Connecting with properties: \n"));
        String registerPackageNames = PropertyDefinition.SKIP_WRAPPING_FOR_PACKAGES.getString(props);
        if (!StringUtils.isNullOrEmpty(registerPackageNames)) {
            String[] packages;
            for (String packageName : packages = registerPackageNames.split(",")) {
                Driver.skipWrappingForPackage(packageName);
            }
        }
        String profileName = PropertyDefinition.PROFILE_NAME.getString(props);
        ConfigurationProfile configurationProfile = null;
        if (!StringUtils.isNullOrEmpty(profileName)) {
            configurationProfile = DriverConfigurationProfiles.getProfileConfiguration(profileName);
            if (configurationProfile != null) {
                PropertyUtils.addProperties(props, configurationProfile.getProperties());
                if (configurationProfile.getAwsCredentialsProviderHandler() != null) {
                    AwsCredentialsManager.setCustomHandler(configurationProfile.getAwsCredentialsProviderHandler());
                }
            } else {
                throw new SQLException(Messages.get("Driver.configurationProfileNotFound", new Object[]{profileName}));
            }
        }
        DefaultTelemetryFactory telemetryFactory = new DefaultTelemetryFactory(props);
        TelemetryContext context = telemetryFactory.openTelemetryContext("software.amazon.jdbc.Driver.connect", TelemetryTraceLevel.TOP_LEVEL);
        try {
            TargetDriverDialect targetDriverDialect;
            String driverUrl = url.replaceFirst(PROTOCOL_PREFIX, "jdbc:");
            TargetDriverHelper helper = new TargetDriverHelper();
            java.sql.Driver driver = helper.getTargetDriver(driverUrl, props);
            String logLevelStr = PropertyDefinition.LOGGER_LEVEL.getString(props);
            if (!StringUtils.isNullOrEmpty(logLevelStr)) {
                Level logLevel = Level.parse(logLevelStr.toUpperCase());
                Logger rootLogger = Logger.getLogger("");
                for (Handler handler : rootLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleHandler) || handler.getLevel().intValue() <= logLevel.intValue()) continue;
                    handler.setLevel(logLevel);
                }
                PARENT_LOGGER.setLevel(logLevel);
            }
            TargetDriverDialect targetDriverDialect2 = targetDriverDialect = configurationProfile == null ? null : configurationProfile.getTargetDriverDialect();
            if (targetDriverDialect == null) {
                TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
                targetDriverDialect = targetDriverDialectManager.getDialect(driver, props);
            }
            DriverConnectionProvider defaultConnectionProvider = new DriverConnectionProvider(driver);
            ConnectionProvider effectiveConnectionProvider = null;
            if (configurationProfile != null) {
                effectiveConnectionProvider = configurationProfile.getConnectionProvider();
            }
            String targetDriverProtocol = this.urlParser.getProtocol(driverUrl);
            FullServicesContainer servicesContainer = ServiceUtility.getInstance().createStandardServiceContainer(this.storageService, this.monitorService, this.eventPublisher, defaultConnectionProvider, effectiveConnectionProvider, telemetryFactory, driverUrl, targetDriverProtocol, targetDriverDialect, props, configurationProfile);
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(servicesContainer, props, url, targetDriverProtocol, configurationProfile);
            return connectionWrapper;
        }
        catch (Exception ex) {
            if (context != null) {
                context.setException(ex);
                context.setSuccess(false);
            }
            throw ex;
        }
        finally {
            if (context != null) {
                context.closeContext();
            }
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(Messages.get("Driver.nullUrl"));
        }
        return url.startsWith(PROTOCOL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties copy = new Properties(info);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(copy, databaseName);
        }
        ConnectionUrlParser.parsePropertiesFromUrl(url, copy);
        Collection<AwsWrapperProperty> knownProperties = PropertyDefinition.allProperties();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.size()];
        int i = 0;
        for (AwsWrapperProperty prop : knownProperties) {
            props[i++] = prop.toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 6;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static void setResetSessionStateOnCloseFunc(@NonNull ResetSessionStateOnCloseCallable func) {
        resetSessionStateOnCloseCallable.set(func);
    }

    public static void resetResetSessionStateOnCloseFunc() {
        resetSessionStateOnCloseCallable.set(null);
    }

    public static ResetSessionStateOnCloseCallable getResetSessionStateOnCloseFunc() {
        return resetSessionStateOnCloseCallable.get();
    }

    public static void setTransferSessionStateOnSwitchFunc(@NonNull TransferSessionStateOnSwitchCallable func) {
        transferSessionStateOnSwitchCallable.set(func);
    }

    public static void resetTransferSessionStateOnSwitchFunc() {
        transferSessionStateOnSwitchCallable.set(null);
    }

    public static TransferSessionStateOnSwitchCallable getTransferSessionStateOnSwitchFunc() {
        return transferSessionStateOnSwitchCallable.get();
    }

    public static void setPrepareHostFunc(Function<String, String> func) {
        RdsUtils.setPrepareHostFunc(func);
    }

    public static void resetPrepareHostFunc() {
        RdsUtils.resetPrepareHostFunc();
    }

    public static void setCustomExceptionHandler(ExceptionHandler exceptionHandler) {
        customExceptionHandler.set(exceptionHandler);
    }

    public static ExceptionHandler getCustomExceptionHandler() {
        return customExceptionHandler.get();
    }

    public static void resetCustomExceptionHandler() {
        customExceptionHandler.set(null);
    }

    public static void setCustomDialect(@NonNull Dialect dialect) {
        customDialect.set(dialect);
    }

    public static Dialect getCustomDialect() {
        return customDialect.get();
    }

    public static void resetCustomDialect() {
        customDialect.set(null);
    }

    public static void setCustomTargetDriverDialect(@NonNull TargetDriverDialect targetDriverDialect) {
        customTargetDriverDialect.set(targetDriverDialect);
    }

    public static TargetDriverDialect getCustomTargetDriverDialect() {
        return customTargetDriverDialect.get();
    }

    public static void resetCustomTargetDriverDialect() {
        customTargetDriverDialect.set(null);
    }

    public static void setCustomConnectionProvider(ConnectionProvider connProvider) {
        customConnectionProvider.set(connProvider);
    }

    public static ConnectionProvider getCustomConnectionProvider() {
        return customConnectionProvider.get();
    }

    public static void resetCustomConnectionProvider() {
        customConnectionProvider.set(null);
    }

    public static void setConnectionInitFunc(@NonNull ConnectionProviderManager.ConnectionInitFunc func) {
        connectionInitFunc.set(func);
    }

    public static ConnectionProviderManager.ConnectionInitFunc getConnectionInitFunc() {
        return connectionInitFunc.get();
    }

    public static void resetConnectionInitFunc() {
        connectionInitFunc.set(null);
    }

    public static void clearCaches() {
        CoreServicesContainer.getInstance().getStorageService().clearAll();
        RdsUtils.clearCache();
        RdsHostListProvider.clearAll();
        PluginServiceImpl.clearCache();
        DialectManager.resetEndpointCache();
        MonitoringRdsHostListProvider.clearCache();
        CustomEndpointMonitorImpl.clearCache();
        OpenedConnectionTracker.clearCache();
        AwsSecretsManagerCacheHolder.clearCache();
        DataCacheConnectionPlugin.clearCache();
        FederatedAuthCacheHolder.clearCache();
        OktaAuthCacheHolder.clearCache();
        IamAuthCacheHolder.clearCache();
        LimitlessRouterServiceImpl.clearCache();
        RoundRobinHostSelector.clearCache();
        FastestResponseStrategyPlugin.clearCache();
    }

    public static void releaseResources() {
        CoreServicesContainer.getInstance().getMonitorService().stopAndRemoveAll();
        HostMonitorThreadContainer.releaseInstance();
        ConnectionProviderManager.releaseResources();
        HikariPoolsHolder.closeAllPools();
        Driver.clearCaches();
    }

    public static void skipWrappingForType(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        WrapperUtils.skipWrappingForClasses.add(clazz);
    }

    public static void skipWrappingForPackage(String packageName) {
        if (packageName == null) {
            return;
        }
        WrapperUtils.skipWrappingForPackages.add(packageName.toLowerCase().trim());
    }

    static {
        resetSessionStateOnCloseCallable = new AtomicReference<Object>(null);
        transferSessionStateOnSwitchCallable = new AtomicReference<Object>(null);
        customExceptionHandler = new AtomicReference<Object>(null);
        customDialect = new AtomicReference<Object>(null);
        customTargetDriverDialect = new AtomicReference<Object>(null);
        customConnectionProvider = new AtomicReference<Object>(null);
        connectionInitFunc = new AtomicReference<Object>(null);
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

