/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class ClobWrapper
implements Clob {
    protected Clob clob;
    protected ConnectionPluginManager pluginManager;

    public ClobWrapper(@NonNull Clob clob, @NonNull ConnectionPluginManager pluginManager) {
        this.clob = clob;
        this.pluginManager = pluginManager;
    }

    @Override
    public long length() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_LENGTH)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_LENGTH, () -> this.clob.length(), new Object[0]);
        }
        return this.clob.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_GETSUBSTRING)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_GETSUBSTRING, () -> this.clob.getSubString(pos, length), pos, length);
        }
        return this.clob.getSubString(pos, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_GETCHARACTERSTREAM)) {
            return WrapperUtils.executeWithPlugins(Reader.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_GETCHARACTERSTREAM, () -> this.clob.getCharacterStream(), new Object[0]);
        }
        return this.clob.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_GETCHARACTERSTREAM)) {
            return WrapperUtils.executeWithPlugins(Reader.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_GETCHARACTERSTREAM, () -> this.clob.getCharacterStream(pos, length), pos, length);
        }
        return this.clob.getCharacterStream(pos, length);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_GETASCIISTREAM)) {
            return WrapperUtils.executeWithPlugins(InputStream.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_GETASCIISTREAM, () -> this.clob.getAsciiStream(), new Object[0]);
        }
        return this.clob.getAsciiStream();
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_POSITION)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_POSITION, () -> this.clob.position(searchStr, start), searchStr, start);
        }
        return this.clob.position(searchStr, start);
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_POSITION)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_POSITION, () -> this.clob.position(searchStr, start), searchStr, start);
        }
        return this.clob.position(searchStr, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_SETSTRING)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_SETSTRING, () -> this.clob.setString(pos, str), pos, str);
        }
        return this.clob.setString(pos, str);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_SETSTRING)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_SETSTRING, () -> this.clob.setString(pos, str, offset, len), pos, str, offset, len);
        }
        return this.clob.setString(pos, str, offset, len);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_SETASCIISTREAM)) {
            return WrapperUtils.executeWithPlugins(OutputStream.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_SETASCIISTREAM, () -> this.clob.setAsciiStream(pos), pos);
        }
        return this.clob.setAsciiStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_SETCHARACTERSTREAM)) {
            return WrapperUtils.executeWithPlugins(Writer.class, SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_SETCHARACTERSTREAM, () -> this.clob.setCharacterStream(pos), pos);
        }
        return this.clob.setCharacterStream(pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_TRUNCATE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_TRUNCATE, () -> this.clob.truncate(len), len);
        } else {
            this.clob.truncate(len);
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.CLOB_FREE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.clob, JdbcMethod.CLOB_FREE, () -> this.clob.free(), new Object[0]);
        } else {
            this.clob.free();
        }
    }

    public String toString() {
        return super.toString() + " - " + this.clob;
    }
}

