/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.events;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.util.events.Event;

public class DataAccessEvent
implements Event {
    protected @NonNull Class<?> dataClass;
    protected @NonNull Object key;

    public DataAccessEvent(@NonNull Class<?> dataClass, @NonNull Object key) {
        this.dataClass = dataClass;
        this.key = key;
    }

    public @NonNull Class<?> getDataClass() {
        return this.dataClass;
    }

    public @NonNull Object getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAccessEvent event = (DataAccessEvent)obj;
        return Objects.equals(this.dataClass, event.dataClass) && Objects.equals(this.key, event.key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataClass.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

