/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.sql.SQLException;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithSamlCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.jdbc.plugin.federatedauth.CredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPlugin;

public abstract class SamlCredentialsProviderFactory
implements CredentialsProviderFactory {
    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(String host, Region region, @NonNull Properties props) throws SQLException {
        String samlAssertion = this.getSamlAssertion(props);
        AssumeRoleWithSamlRequest assumeRoleWithSamlRequest = (AssumeRoleWithSamlRequest)AssumeRoleWithSamlRequest.builder().samlAssertion(samlAssertion).roleArn(FederatedAuthPlugin.IAM_ROLE_ARN.getString(props)).principalArn(FederatedAuthPlugin.IAM_IDP_ARN.getString(props)).build();
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).region(region)).build();
        return ((StsAssumeRoleWithSamlCredentialsProvider.Builder)((StsAssumeRoleWithSamlCredentialsProvider.Builder)StsAssumeRoleWithSamlCredentialsProvider.builder().refreshRequest(assumeRoleWithSamlRequest).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).stsClient(stsClient)).build();
    }

    abstract String getSamlAssertion(@NonNull Properties var1) throws SQLException;
}

