/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.util.Optional;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.ExecuteRouting;
import software.amazon.jdbc.util.storage.StorageService;

public abstract class BaseExecuteRouting
extends BaseRouting
implements ExecuteRouting {
    protected final String hostAndPort;
    protected BlueGreenRole role;

    public BaseExecuteRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role) {
        this.hostAndPort = hostAndPort == null ? null : hostAndPort.toLowerCase();
        this.role = role;
    }

    @Override
    public boolean isMatch(HostSpec hostSpec, BlueGreenRole hostRole) {
        return !(this.hostAndPort != null && !this.hostAndPort.equals(hostSpec == null ? null : hostSpec.getHostAndPort().toLowerCase()) || this.role != null && !this.role.equals((Object)hostRole));
    }

    @Override
    public abstract <T, E extends Exception> @NonNull Optional<T> apply(ConnectionPlugin var1, Class<T> var2, Class<E> var3, Object var4, String var5, JdbcCallable<T, E> var6, Object[] var7, StorageService var8, PluginService var9, Properties var10) throws E;

    public String toString() {
        return String.format("%s [%s, %s]", super.toString(), this.hostAndPort == null ? "<null>" : this.hostAndPort, this.role == null ? "<null>" : this.role.toString());
    }
}

