/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.DriverPropertyInfo;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AwsWrapperProperty
extends DriverPropertyInfo {
    public final @Nullable String defaultValue;

    public AwsWrapperProperty(@NonNull String name, @Nullable String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    public AwsWrapperProperty(@NonNull String name, @Nullable String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
    }

    public AwsWrapperProperty(@NonNull String name, @Nullable String defaultValue, String description, boolean required, @Nullable String[] choices) {
        super(name, null);
        this.defaultValue = defaultValue;
        this.required = required;
        this.description = description;
        this.choices = choices;
    }

    public @Nullable String getString(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public boolean getBoolean(Properties properties) {
        Object value = properties.get(this.name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(properties.getProperty(this.name, this.defaultValue));
    }

    public int getInteger(Properties properties) {
        Object value = properties.get(this.name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(properties.getProperty(this.name, this.defaultValue));
    }

    public long getLong(Properties properties) {
        Object value = properties.get(this.name);
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(properties.getProperty(this.name, this.defaultValue));
    }

    public void set(Properties properties, @Nullable String value) {
        if (value == null) {
            properties.remove(this.name);
        } else {
            properties.setProperty(this.name, value);
        }
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this.name, this.getString(properties));
        propertyInfo.required = this.required;
        propertyInfo.description = this.description;
        propertyInfo.choices = this.choices;
        return propertyInfo;
    }
}

