/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeRangeType {
    TRACE_ID("TraceId"),
    EVENT("Event"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeRangeType> VALUE_MAP;
    private final String value;

    private TimeRangeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeRangeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeRangeType> knownValues() {
        EnumSet<TimeRangeType> knownValues = EnumSet.allOf(TimeRangeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeRangeType.class, TimeRangeType::toString);
    }
}

