/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.IpRule;
import software.amazon.awssdk.services.workspacesweb.model.IpRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAccessSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAccessSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(IpAccessSettings.getter(IpAccessSettings::associatedPortalArns)).setter(IpAccessSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(IpAccessSettings.getter(IpAccessSettings::creationDate)).setter(IpAccessSettings.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IpAccessSettings.getter(IpAccessSettings::description)).setter(IpAccessSettings.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(IpAccessSettings.getter(IpAccessSettings::displayName)).setter(IpAccessSettings.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAccessSettingsArn").getter(IpAccessSettings.getter(IpAccessSettings::ipAccessSettingsArn)).setter(IpAccessSettings.setter(Builder::ipAccessSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build()}).build();
    private static final SdkField<List<IpRule>> IP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipRules").getter(IpAccessSettings.getter(IpAccessSettings::ipRules)).setter(IpAccessSettings.setter(Builder::ipRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD, IP_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> associatedPortalArns;
    private final Instant creationDate;
    private final String description;
    private final String displayName;
    private final String ipAccessSettingsArn;
    private final List<IpRule> ipRules;

    private IpAccessSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.ipRules = builder.ipRules;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String ipAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public final boolean hasIpRules() {
        return this.ipRules != null && !(this.ipRules instanceof SdkAutoConstructList);
    }

    public final List<IpRule> ipRules() {
        return this.ipRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRules() ? this.ipRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettings)) {
            return false;
        }
        IpAccessSettings other = (IpAccessSettings)obj;
        return this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.ipAccessSettingsArn(), other.ipAccessSettingsArn()) && this.hasIpRules() == other.hasIpRules() && Objects.equals(this.ipRules(), other.ipRules());
    }

    public final String toString() {
        return ToString.builder((String)"IpAccessSettings").add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("CreationDate", (Object)this.creationDate()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("IpAccessSettingsArn", (Object)this.ipAccessSettingsArn()).add("IpRules", (Object)(this.ipRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ipAccessSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.ipAccessSettingsArn()));
            }
            case "ipRules": {
                return Optional.ofNullable(clazz.cast(this.ipRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAccessSettings, T> g) {
        return obj -> g.apply((IpAccessSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private String description;
        private String displayName;
        private String ipAccessSettingsArn;
        private List<IpRule> ipRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpAccessSettings model) {
            this.associatedPortalArns(model.associatedPortalArns);
            this.creationDate(model.creationDate);
            this.description(model.description);
            this.displayName(model.displayName);
            this.ipAccessSettingsArn(model.ipAccessSettingsArn);
            this.ipRules(model.ipRules);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final List<IpRule.Builder> getIpRules() {
            List<IpRule.Builder> result = IpRuleListCopier.copyToBuilder(this.ipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRules(Collection<IpRule.BuilderImpl> ipRules) {
            this.ipRules = IpRuleListCopier.copyFromBuilder(ipRules);
        }

        @Override
        public final Builder ipRules(Collection<IpRule> ipRules) {
            this.ipRules = IpRuleListCopier.copy(ipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(IpRule ... ipRules) {
            this.ipRules(Arrays.asList(ipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(Consumer<IpRule.Builder> ... ipRules) {
            this.ipRules(Stream.of(ipRules).map(c -> (IpRule)((IpRule.Builder)IpRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpAccessSettings build() {
            return new IpAccessSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAccessSettings> {
        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder ipAccessSettingsArn(String var1);

        public Builder ipRules(Collection<IpRule> var1);

        public Builder ipRules(IpRule ... var1);

        public Builder ipRules(Consumer<IpRule.Builder> ... var1);
    }
}

