/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPortalsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListPortalsResponse.Builder, ListPortalsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPortalsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PortalSummary>> PORTALS_FIELD = SdkField
            .<List<PortalSummary>> builder(MarshallingType.LIST)
            .memberName("portals")
            .getter(getter(ListPortalsResponse::portals))
            .setter(setter(Builder::portals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortalSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortalSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PORTALS_FIELD));

    private final String nextToken;

    private final List<PortalSummary> portals;

    private ListPortalsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.portals = builder.portals;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Portals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortals() {
        return portals != null && !(portals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The portals in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortals} method.
     * </p>
     * 
     * @return The portals in the list.
     */
    public final List<PortalSummary> portals() {
        return portals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortals() ? portals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortalsResponse)) {
            return false;
        }
        ListPortalsResponse other = (ListPortalsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPortals() == other.hasPortals()
                && Objects.equals(portals(), other.portals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPortalsResponse").add("NextToken", nextToken())
                .add("Portals", hasPortals() ? portals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "portals":
            return Optional.ofNullable(clazz.cast(portals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortalsResponse, T> g) {
        return obj -> g.apply((ListPortalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPortalsResponse> {
        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The portals in the list.
         * </p>
         * 
         * @param portals
         *        The portals in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portals(Collection<PortalSummary> portals);

        /**
         * <p>
         * The portals in the list.
         * </p>
         * 
         * @param portals
         *        The portals in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portals(PortalSummary... portals);

        /**
         * <p>
         * The portals in the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.PortalSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspacesweb.model.PortalSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.PortalSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #portals(List<PortalSummary>)}.
         * 
         * @param portals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.PortalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portals(java.util.Collection<PortalSummary>)
         */
        Builder portals(Consumer<PortalSummary.Builder>... portals);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PortalSummary> portals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortalsResponse model) {
            super(model);
            nextToken(model.nextToken);
            portals(model.portals);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PortalSummary.Builder> getPortals() {
            List<PortalSummary.Builder> result = PortalListCopier.copyToBuilder(this.portals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortals(Collection<PortalSummary.BuilderImpl> portals) {
            this.portals = PortalListCopier.copyFromBuilder(portals);
        }

        @Override
        public final Builder portals(Collection<PortalSummary> portals) {
            this.portals = PortalListCopier.copy(portals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portals(PortalSummary... portals) {
            portals(Arrays.asList(portals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portals(Consumer<PortalSummary.Builder>... portals) {
            portals(Stream.of(portals).map(c -> PortalSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPortalsResponse build() {
            return new ListPortalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
