/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IP access control group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspacesIpGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspacesIpGroup.Builder, WorkspacesIpGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupId").getter(getter(WorkspacesIpGroup::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(WorkspacesIpGroup::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> GROUP_DESC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupDesc").getter(getter(WorkspacesIpGroup::groupDesc)).setter(setter(Builder::groupDesc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDesc").build()).build();

    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField
            .<List<IpRuleItem>> builder(MarshallingType.LIST)
            .memberName("userRules")
            .getter(getter(WorkspacesIpGroup::userRules))
            .setter(setter(Builder::userRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRuleItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRuleItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            GROUP_NAME_FIELD, GROUP_DESC_FIELD, USER_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String groupName;

    private final String groupDesc;

    private final List<IpRuleItem> userRules;

    private WorkspacesIpGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.groupDesc = builder.groupDesc;
        this.userRules = builder.userRules;
    }

    /**
     * <p>
     * The identifier of the group.
     * </p>
     * 
     * @return The identifier of the group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The description of the group.
     * </p>
     * 
     * @return The description of the group.
     */
    public final String groupDesc() {
        return groupDesc;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserRules() {
        return userRules != null && !(userRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserRules} method.
     * </p>
     * 
     * @return The rules.
     */
    public final List<IpRuleItem> userRules() {
        return userRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupDesc());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserRules() ? userRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesIpGroup)) {
            return false;
        }
        WorkspacesIpGroup other = (WorkspacesIpGroup) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(groupDesc(), other.groupDesc()) && hasUserRules() == other.hasUserRules()
                && Objects.equals(userRules(), other.userRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspacesIpGroup").add("GroupId", groupId()).add("GroupName", groupName())
                .add("GroupDesc", groupDesc()).add("UserRules", hasUserRules() ? userRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "groupDesc":
            return Optional.ofNullable(clazz.cast(groupDesc()));
        case "userRules":
            return Optional.ofNullable(clazz.cast(userRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesIpGroup, T> g) {
        return obj -> g.apply((WorkspacesIpGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspacesIpGroup> {
        /**
         * <p>
         * The identifier of the group.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The description of the group.
         * </p>
         * 
         * @param groupDesc
         *        The description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDesc(String groupDesc);

        /**
         * <p>
         * The rules.
         * </p>
         * 
         * @param userRules
         *        The rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(Collection<IpRuleItem> userRules);

        /**
         * <p>
         * The rules.
         * </p>
         * 
         * @param userRules
         *        The rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(IpRuleItem... userRules);

        /**
         * <p>
         * The rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder#build()} is called immediately and
         * its result is passed to {@link #userRules(List<IpRuleItem>)}.
         * 
         * @param userRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userRules(java.util.Collection<IpRuleItem>)
         */
        Builder userRules(Consumer<IpRuleItem.Builder>... userRules);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private String groupDesc;

        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesIpGroup model) {
            groupId(model.groupId);
            groupName(model.groupName);
            groupDesc(model.groupDesc);
            userRules(model.userRules);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupDesc() {
            return groupDesc;
        }

        public final void setGroupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
        }

        @Override
        public final Builder groupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
            return this;
        }

        public final List<IpRuleItem.Builder> getUserRules() {
            List<IpRuleItem.Builder> result = IpRuleListCopier.copyToBuilder(this.userRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem... userRules) {
            userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder>... userRules) {
            userRules(Stream.of(userRules).map(c -> IpRuleItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WorkspacesIpGroup build() {
            return new WorkspacesIpGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
