/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the WorkSpace application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkSpaceApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkSpaceApplication.Builder, WorkSpaceApplication> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(WorkSpaceApplication::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(WorkSpaceApplication::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WorkSpaceApplication::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseType").getter(getter(WorkSpaceApplication::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WorkSpaceApplication::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(WorkSpaceApplication::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(WorkSpaceApplication::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<String>> SUPPORTED_COMPUTE_TYPE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedComputeTypeNames")
            .getter(getter(WorkSpaceApplication::supportedComputeTypeNamesAsStrings))
            .setter(setter(Builder::supportedComputeTypeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedComputeTypeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_OPERATING_SYSTEM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedOperatingSystemNames")
            .getter(getter(WorkSpaceApplication::supportedOperatingSystemNamesAsStrings))
            .setter(setter(Builder::supportedOperatingSystemNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedOperatingSystemNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATED_FIELD, DESCRIPTION_FIELD, LICENSE_TYPE_FIELD, NAME_FIELD, OWNER_FIELD, STATE_FIELD,
            SUPPORTED_COMPUTE_TYPE_NAMES_FIELD, SUPPORTED_OPERATING_SYSTEM_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final Instant created;

    private final String description;

    private final String licenseType;

    private final String name;

    private final String owner;

    private final String state;

    private final List<String> supportedComputeTypeNames;

    private final List<String> supportedOperatingSystemNames;

    private WorkSpaceApplication(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.created = builder.created;
        this.description = builder.description;
        this.licenseType = builder.licenseType;
        this.name = builder.name;
        this.owner = builder.owner;
        this.state = builder.state;
        this.supportedComputeTypeNames = builder.supportedComputeTypeNames;
        this.supportedOperatingSystemNames = builder.supportedOperatingSystemNames;
    }

    /**
     * <p>
     * The identifier of the application.
     * </p>
     * 
     * @return The identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The time the application is created.
     * </p>
     * 
     * @return The time the application is created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The description of the WorkSpace application.
     * </p>
     * 
     * @return The description of the WorkSpace application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The license availability for the applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link WorkSpaceApplicationLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license availability for the applications.
     * @see WorkSpaceApplicationLicenseType
     */
    public final WorkSpaceApplicationLicenseType licenseType() {
        return WorkSpaceApplicationLicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The license availability for the applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link WorkSpaceApplicationLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license availability for the applications.
     * @see WorkSpaceApplicationLicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The name of the WorkSpace application.
     * </p>
     * 
     * @return The name of the WorkSpace application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the WorkSpace application.
     * </p>
     * 
     * @return The owner of the WorkSpace application.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The status of WorkSpace application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkSpaceApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of WorkSpace application.
     * @see WorkSpaceApplicationState
     */
    public final WorkSpaceApplicationState state() {
        return WorkSpaceApplicationState.fromValue(state);
    }

    /**
     * <p>
     * The status of WorkSpace application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkSpaceApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of WorkSpace application.
     * @see WorkSpaceApplicationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The supported compute types of the WorkSpace application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComputeTypeNames} method.
     * </p>
     * 
     * @return The supported compute types of the WorkSpace application.
     */
    public final List<Compute> supportedComputeTypeNames() {
        return ComputeListCopier.copyStringToEnum(supportedComputeTypeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedComputeTypeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedComputeTypeNames() {
        return supportedComputeTypeNames != null && !(supportedComputeTypeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported compute types of the WorkSpace application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComputeTypeNames} method.
     * </p>
     * 
     * @return The supported compute types of the WorkSpace application.
     */
    public final List<String> supportedComputeTypeNamesAsStrings() {
        return supportedComputeTypeNames;
    }

    /**
     * <p>
     * The supported operating systems of the WorkSpace application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedOperatingSystemNames} method.
     * </p>
     * 
     * @return The supported operating systems of the WorkSpace application.
     */
    public final List<OperatingSystemName> supportedOperatingSystemNames() {
        return OperatingSystemNameListCopier.copyStringToEnum(supportedOperatingSystemNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedOperatingSystemNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedOperatingSystemNames() {
        return supportedOperatingSystemNames != null && !(supportedOperatingSystemNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported operating systems of the WorkSpace application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedOperatingSystemNames} method.
     * </p>
     * 
     * @return The supported operating systems of the WorkSpace application.
     */
    public final List<String> supportedOperatingSystemNamesAsStrings() {
        return supportedOperatingSystemNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedComputeTypeNames() ? supportedComputeTypeNamesAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedOperatingSystemNames() ? supportedOperatingSystemNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkSpaceApplication)) {
            return false;
        }
        WorkSpaceApplication other = (WorkSpaceApplication) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(created(), other.created())
                && Objects.equals(description(), other.description())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasSupportedComputeTypeNames() == other.hasSupportedComputeTypeNames()
                && Objects.equals(supportedComputeTypeNamesAsStrings(), other.supportedComputeTypeNamesAsStrings())
                && hasSupportedOperatingSystemNames() == other.hasSupportedOperatingSystemNames()
                && Objects.equals(supportedOperatingSystemNamesAsStrings(), other.supportedOperatingSystemNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("WorkSpaceApplication")
                .add("ApplicationId", applicationId())
                .add("Created", created())
                .add("Description", description())
                .add("LicenseType", licenseTypeAsString())
                .add("Name", name())
                .add("Owner", owner())
                .add("State", stateAsString())
                .add("SupportedComputeTypeNames", hasSupportedComputeTypeNames() ? supportedComputeTypeNamesAsStrings() : null)
                .add("SupportedOperatingSystemNames",
                        hasSupportedOperatingSystemNames() ? supportedOperatingSystemNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "SupportedComputeTypeNames":
            return Optional.ofNullable(clazz.cast(supportedComputeTypeNamesAsStrings()));
        case "SupportedOperatingSystemNames":
            return Optional.ofNullable(clazz.cast(supportedOperatingSystemNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkSpaceApplication, T> g) {
        return obj -> g.apply((WorkSpaceApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkSpaceApplication> {
        /**
         * <p>
         * The identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The time the application is created.
         * </p>
         * 
         * @param created
         *        The time the application is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The description of the WorkSpace application.
         * </p>
         * 
         * @param description
         *        The description of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The license availability for the applications.
         * </p>
         * 
         * @param licenseType
         *        The license availability for the applications.
         * @see WorkSpaceApplicationLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationLicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license availability for the applications.
         * </p>
         * 
         * @param licenseType
         *        The license availability for the applications.
         * @see WorkSpaceApplicationLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationLicenseType
         */
        Builder licenseType(WorkSpaceApplicationLicenseType licenseType);

        /**
         * <p>
         * The name of the WorkSpace application.
         * </p>
         * 
         * @param name
         *        The name of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the WorkSpace application.
         * </p>
         * 
         * @param owner
         *        The owner of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The status of WorkSpace application.
         * </p>
         * 
         * @param state
         *        The status of WorkSpace application.
         * @see WorkSpaceApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of WorkSpace application.
         * </p>
         * 
         * @param state
         *        The status of WorkSpace application.
         * @see WorkSpaceApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationState
         */
        Builder state(WorkSpaceApplicationState state);

        /**
         * <p>
         * The supported compute types of the WorkSpace application.
         * </p>
         * 
         * @param supportedComputeTypeNames
         *        The supported compute types of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeTypeNamesWithStrings(Collection<String> supportedComputeTypeNames);

        /**
         * <p>
         * The supported compute types of the WorkSpace application.
         * </p>
         * 
         * @param supportedComputeTypeNames
         *        The supported compute types of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeTypeNamesWithStrings(String... supportedComputeTypeNames);

        /**
         * <p>
         * The supported compute types of the WorkSpace application.
         * </p>
         * 
         * @param supportedComputeTypeNames
         *        The supported compute types of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeTypeNames(Collection<Compute> supportedComputeTypeNames);

        /**
         * <p>
         * The supported compute types of the WorkSpace application.
         * </p>
         * 
         * @param supportedComputeTypeNames
         *        The supported compute types of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeTypeNames(Compute... supportedComputeTypeNames);

        /**
         * <p>
         * The supported operating systems of the WorkSpace application.
         * </p>
         * 
         * @param supportedOperatingSystemNames
         *        The supported operating systems of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatingSystemNamesWithStrings(Collection<String> supportedOperatingSystemNames);

        /**
         * <p>
         * The supported operating systems of the WorkSpace application.
         * </p>
         * 
         * @param supportedOperatingSystemNames
         *        The supported operating systems of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatingSystemNamesWithStrings(String... supportedOperatingSystemNames);

        /**
         * <p>
         * The supported operating systems of the WorkSpace application.
         * </p>
         * 
         * @param supportedOperatingSystemNames
         *        The supported operating systems of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatingSystemNames(Collection<OperatingSystemName> supportedOperatingSystemNames);

        /**
         * <p>
         * The supported operating systems of the WorkSpace application.
         * </p>
         * 
         * @param supportedOperatingSystemNames
         *        The supported operating systems of the WorkSpace application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatingSystemNames(OperatingSystemName... supportedOperatingSystemNames);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private Instant created;

        private String description;

        private String licenseType;

        private String name;

        private String owner;

        private String state;

        private List<String> supportedComputeTypeNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedOperatingSystemNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkSpaceApplication model) {
            applicationId(model.applicationId);
            created(model.created);
            description(model.description);
            licenseType(model.licenseType);
            name(model.name);
            owner(model.owner);
            state(model.state);
            supportedComputeTypeNamesWithStrings(model.supportedComputeTypeNames);
            supportedOperatingSystemNamesWithStrings(model.supportedOperatingSystemNames);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(WorkSpaceApplicationLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkSpaceApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getSupportedComputeTypeNames() {
            if (supportedComputeTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedComputeTypeNames;
        }

        public final void setSupportedComputeTypeNames(Collection<String> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copy(supportedComputeTypeNames);
        }

        @Override
        public final Builder supportedComputeTypeNamesWithStrings(Collection<String> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copy(supportedComputeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeTypeNamesWithStrings(String... supportedComputeTypeNames) {
            supportedComputeTypeNamesWithStrings(Arrays.asList(supportedComputeTypeNames));
            return this;
        }

        @Override
        public final Builder supportedComputeTypeNames(Collection<Compute> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copyEnumToString(supportedComputeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeTypeNames(Compute... supportedComputeTypeNames) {
            supportedComputeTypeNames(Arrays.asList(supportedComputeTypeNames));
            return this;
        }

        public final Collection<String> getSupportedOperatingSystemNames() {
            if (supportedOperatingSystemNames instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedOperatingSystemNames;
        }

        public final void setSupportedOperatingSystemNames(Collection<String> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copy(supportedOperatingSystemNames);
        }

        @Override
        public final Builder supportedOperatingSystemNamesWithStrings(Collection<String> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copy(supportedOperatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatingSystemNamesWithStrings(String... supportedOperatingSystemNames) {
            supportedOperatingSystemNamesWithStrings(Arrays.asList(supportedOperatingSystemNames));
            return this;
        }

        @Override
        public final Builder supportedOperatingSystemNames(Collection<OperatingSystemName> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copyEnumToString(supportedOperatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatingSystemNames(OperatingSystemName... supportedOperatingSystemNames) {
            supportedOperatingSystemNames(Arrays.asList(supportedOperatingSystemNames));
            return this;
        }

        @Override
        public WorkSpaceApplication build() {
            return new WorkSpaceApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
