/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ComputeType;
import software.amazon.awssdk.services.workspaces.model.RootStorage;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.UserStorage;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceBundleRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateWorkspaceBundleRequest> {
    private static final SdkField<String> BUNDLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleName").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::bundleName)).setter(CreateWorkspaceBundleRequest.setter(Builder::bundleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleName").build()}).build();
    private static final SdkField<String> BUNDLE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleDescription").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::bundleDescription)).setter(CreateWorkspaceBundleRequest.setter(Builder::bundleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleDescription").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::imageId)).setter(CreateWorkspaceBundleRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<ComputeType> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeType").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::computeType)).setter(CreateWorkspaceBundleRequest.setter(Builder::computeType)).constructor(ComputeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()}).build();
    private static final SdkField<UserStorage> USER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserStorage").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::userStorage)).setter(CreateWorkspaceBundleRequest.setter(Builder::userStorage)).constructor(UserStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStorage").build()}).build();
    private static final SdkField<RootStorage> ROOT_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootStorage").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::rootStorage)).setter(CreateWorkspaceBundleRequest.setter(Builder::rootStorage)).constructor(RootStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootStorage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWorkspaceBundleRequest.getter(CreateWorkspaceBundleRequest::tags)).setter(CreateWorkspaceBundleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_NAME_FIELD, BUNDLE_DESCRIPTION_FIELD, IMAGE_ID_FIELD, COMPUTE_TYPE_FIELD, USER_STORAGE_FIELD, ROOT_STORAGE_FIELD, TAGS_FIELD));
    private final String bundleName;
    private final String bundleDescription;
    private final String imageId;
    private final ComputeType computeType;
    private final UserStorage userStorage;
    private final RootStorage rootStorage;
    private final List<Tag> tags;

    private CreateWorkspaceBundleRequest(BuilderImpl builder) {
        super(builder);
        this.bundleName = builder.bundleName;
        this.bundleDescription = builder.bundleDescription;
        this.imageId = builder.imageId;
        this.computeType = builder.computeType;
        this.userStorage = builder.userStorage;
        this.rootStorage = builder.rootStorage;
        this.tags = builder.tags;
    }

    public final String bundleName() {
        return this.bundleName;
    }

    public final String bundleDescription() {
        return this.bundleDescription;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final ComputeType computeType() {
        return this.computeType;
    }

    public final UserStorage userStorage() {
        return this.userStorage;
    }

    public final RootStorage rootStorage() {
        return this.rootStorage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceBundleRequest)) {
            return false;
        }
        CreateWorkspaceBundleRequest other = (CreateWorkspaceBundleRequest)((Object)obj);
        return Objects.equals(this.bundleName(), other.bundleName()) && Objects.equals(this.bundleDescription(), other.bundleDescription()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.computeType(), other.computeType()) && Objects.equals(this.userStorage(), other.userStorage()) && Objects.equals(this.rootStorage(), other.rootStorage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceBundleRequest").add("BundleName", (Object)this.bundleName()).add("BundleDescription", (Object)this.bundleDescription()).add("ImageId", (Object)this.imageId()).add("ComputeType", (Object)this.computeType()).add("UserStorage", (Object)this.userStorage()).add("RootStorage", (Object)this.rootStorage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleName": {
                return Optional.ofNullable(clazz.cast(this.bundleName()));
            }
            case "BundleDescription": {
                return Optional.ofNullable(clazz.cast(this.bundleDescription()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ComputeType": {
                return Optional.ofNullable(clazz.cast(this.computeType()));
            }
            case "UserStorage": {
                return Optional.ofNullable(clazz.cast(this.userStorage()));
            }
            case "RootStorage": {
                return Optional.ofNullable(clazz.cast(this.rootStorage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceBundleRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceBundleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String bundleName;
        private String bundleDescription;
        private String imageId;
        private ComputeType computeType;
        private UserStorage userStorage;
        private RootStorage rootStorage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceBundleRequest model) {
            super(model);
            this.bundleName(model.bundleName);
            this.bundleDescription(model.bundleDescription);
            this.imageId(model.imageId);
            this.computeType(model.computeType);
            this.userStorage(model.userStorage);
            this.rootStorage(model.rootStorage);
            this.tags(model.tags);
        }

        public final String getBundleName() {
            return this.bundleName;
        }

        public final void setBundleName(String bundleName) {
            this.bundleName = bundleName;
        }

        @Override
        public final Builder bundleName(String bundleName) {
            this.bundleName = bundleName;
            return this;
        }

        public final String getBundleDescription() {
            return this.bundleDescription;
        }

        public final void setBundleDescription(String bundleDescription) {
            this.bundleDescription = bundleDescription;
        }

        @Override
        public final Builder bundleDescription(String bundleDescription) {
            this.bundleDescription = bundleDescription;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final ComputeType.Builder getComputeType() {
            return this.computeType != null ? this.computeType.toBuilder() : null;
        }

        public final void setComputeType(ComputeType.BuilderImpl computeType) {
            this.computeType = computeType != null ? computeType.build() : null;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        public final UserStorage.Builder getUserStorage() {
            return this.userStorage != null ? this.userStorage.toBuilder() : null;
        }

        public final void setUserStorage(UserStorage.BuilderImpl userStorage) {
            this.userStorage = userStorage != null ? userStorage.build() : null;
        }

        @Override
        public final Builder userStorage(UserStorage userStorage) {
            this.userStorage = userStorage;
            return this;
        }

        public final RootStorage.Builder getRootStorage() {
            return this.rootStorage != null ? this.rootStorage.toBuilder() : null;
        }

        public final void setRootStorage(RootStorage.BuilderImpl rootStorage) {
            this.rootStorage = rootStorage != null ? rootStorage.build() : null;
        }

        @Override
        public final Builder rootStorage(RootStorage rootStorage) {
            this.rootStorage = rootStorage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceBundleRequest build() {
            return new CreateWorkspaceBundleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceBundleRequest> {
        public Builder bundleName(String var1);

        public Builder bundleDescription(String var1);

        public Builder imageId(String var1);

        public Builder computeType(ComputeType var1);

        default public Builder computeType(Consumer<ComputeType.Builder> computeType) {
            return this.computeType((ComputeType)((ComputeType.Builder)ComputeType.builder().applyMutation(computeType)).build());
        }

        public Builder userStorage(UserStorage var1);

        default public Builder userStorage(Consumer<UserStorage.Builder> userStorage) {
            return this.userStorage((UserStorage)((UserStorage.Builder)UserStorage.builder().applyMutation(userStorage)).build());
        }

        public Builder rootStorage(RootStorage var1);

        default public Builder rootStorage(Consumer<RootStorage.Builder> rootStorage) {
            return this.rootStorage((RootStorage)((RootStorage.Builder)RootStorage.builder().applyMutation(rootStorage)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

