/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectClientAddInRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<UpdateConnectClientAddInRequest.Builder, UpdateConnectClientAddInRequest> {
    private static final SdkField<String> ADD_IN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddInId").getter(getter(UpdateConnectClientAddInRequest::addInId)).setter(setter(Builder::addInId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddInId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateConnectClientAddInRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConnectClientAddInRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URL")
            .getter(getter(UpdateConnectClientAddInRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_IN_ID_FIELD,
            RESOURCE_ID_FIELD, NAME_FIELD, URL_FIELD));

    private final String addInId;

    private final String resourceId;

    private final String name;

    private final String url;

    private UpdateConnectClientAddInRequest(BuilderImpl builder) {
        super(builder);
        this.addInId = builder.addInId;
        this.resourceId = builder.resourceId;
        this.name = builder.name;
        this.url = builder.url;
    }

    /**
     * <p>
     * The identifier of the client add-in to update.
     * </p>
     * 
     * @return The identifier of the client add-in to update.
     */
    public final String addInId() {
        return addInId;
    }

    /**
     * <p>
     * The directory identifier for which the client add-in is configured.
     * </p>
     * 
     * @return The directory identifier for which the client add-in is configured.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The name of the client add-in.
     * </p>
     * 
     * @return The name of the client add-in.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The endpoint URL of the Amazon Connect client add-in.
     * </p>
     * 
     * @return The endpoint URL of the Amazon Connect client add-in.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addInId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectClientAddInRequest)) {
            return false;
        }
        UpdateConnectClientAddInRequest other = (UpdateConnectClientAddInRequest) obj;
        return Objects.equals(addInId(), other.addInId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(name(), other.name()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectClientAddInRequest").add("AddInId", addInId()).add("ResourceId", resourceId())
                .add("Name", name()).add("URL", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddInId":
            return Optional.ofNullable(clazz.cast(addInId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "URL":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectClientAddInRequest, T> g) {
        return obj -> g.apply((UpdateConnectClientAddInRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectClientAddInRequest> {
        /**
         * <p>
         * The identifier of the client add-in to update.
         * </p>
         * 
         * @param addInId
         *        The identifier of the client add-in to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addInId(String addInId);

        /**
         * <p>
         * The directory identifier for which the client add-in is configured.
         * </p>
         * 
         * @param resourceId
         *        The directory identifier for which the client add-in is configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The name of the client add-in.
         * </p>
         * 
         * @param name
         *        The name of the client add-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The endpoint URL of the Amazon Connect client add-in.
         * </p>
         * 
         * @param url
         *        The endpoint URL of the Amazon Connect client add-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String addInId;

        private String resourceId;

        private String name;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectClientAddInRequest model) {
            super(model);
            addInId(model.addInId);
            resourceId(model.resourceId);
            name(model.name);
            url(model.url);
        }

        public final String getAddInId() {
            return addInId;
        }

        public final void setAddInId(String addInId) {
            this.addInId = addInId;
        }

        @Override
        public final Builder addInId(String addInId) {
            this.addInId = addInId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectClientAddInRequest build() {
            return new UpdateConnectClientAddInRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
