/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions for a connection alias. Connection aliases are used for cross-Region redirection. For more
 * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
 * Cross-Region Redirection for Amazon WorkSpaces</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionAliasPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionAliasPermission.Builder, ConnectionAliasPermission> {
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedAccountId").getter(getter(ConnectionAliasPermission::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()).build();

    private static final SdkField<Boolean> ALLOW_ASSOCIATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowAssociation").getter(getter(ConnectionAliasPermission::allowAssociation))
            .setter(setter(Builder::allowAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_ACCOUNT_ID_FIELD,
            ALLOW_ASSOCIATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sharedAccountId;

    private final Boolean allowAssociation;

    private ConnectionAliasPermission(BuilderImpl builder) {
        this.sharedAccountId = builder.sharedAccountId;
        this.allowAssociation = builder.allowAssociation;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that the connection alias is shared with.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that the connection alias is shared with.
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a
     * directory.
     * </p>
     * 
     * @return Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias
     *         with a directory.
     */
    public final Boolean allowAssociation() {
        return allowAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(allowAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAliasPermission)) {
            return false;
        }
        ConnectionAliasPermission other = (ConnectionAliasPermission) obj;
        return Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(allowAssociation(), other.allowAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionAliasPermission").add("SharedAccountId", sharedAccountId())
                .add("AllowAssociation", allowAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "AllowAssociation":
            return Optional.ofNullable(clazz.cast(allowAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAliasPermission, T> g) {
        return obj -> g.apply((ConnectionAliasPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionAliasPermission> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account that the connection alias is shared with.
         * </p>
         * 
         * @param sharedAccountId
         *        The identifier of the Amazon Web Services account that the connection alias is shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with
         * a directory.
         * </p>
         * 
         * @param allowAssociation
         *        Indicates whether the specified Amazon Web Services account is allowed to associate the connection
         *        alias with a directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAssociation(Boolean allowAssociation);
    }

    static final class BuilderImpl implements Builder {
        private String sharedAccountId;

        private Boolean allowAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAliasPermission model) {
            sharedAccountId(model.sharedAccountId);
            allowAssociation(model.allowAssociation);
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final Boolean getAllowAssociation() {
            return allowAssociation;
        }

        public final void setAllowAssociation(Boolean allowAssociation) {
            this.allowAssociation = allowAssociation;
        }

        @Override
        public final Builder allowAssociation(Boolean allowAssociation) {
            this.allowAssociation = allowAssociation;
            return this;
        }

        @Override
        public ConnectionAliasPermission build() {
            return new ConnectionAliasPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
