/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon WorkSpaces client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientProperties.Builder, ClientProperties> {
    private static final SdkField<String> RECONNECT_ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReconnectEnabled").getter(getter(ClientProperties::reconnectEnabledAsString))
            .setter(setter(Builder::reconnectEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReconnectEnabled").build()).build();

    private static final SdkField<String> LOG_UPLOAD_ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogUploadEnabled").getter(getter(ClientProperties::logUploadEnabledAsString))
            .setter(setter(Builder::logUploadEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUploadEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECONNECT_ENABLED_FIELD,
            LOG_UPLOAD_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reconnectEnabled;

    private final String logUploadEnabled;

    private ClientProperties(BuilderImpl builder) {
        this.reconnectEnabled = builder.reconnectEnabled;
        this.logUploadEnabled = builder.logUploadEnabled;
    }

    /**
     * <p>
     * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can
     * choose to reconnect to their WorkSpaces without re-entering their credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reconnectEnabled}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reconnectEnabledAsString}.
     * </p>
     * 
     * @return Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users
     *         can choose to reconnect to their WorkSpaces without re-entering their credentials.
     * @see ReconnectEnum
     */
    public final ReconnectEnum reconnectEnabled() {
        return ReconnectEnum.fromValue(reconnectEnabled);
    }

    /**
     * <p>
     * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can
     * choose to reconnect to their WorkSpaces without re-entering their credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reconnectEnabled}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reconnectEnabledAsString}.
     * </p>
     * 
     * @return Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users
     *         can choose to reconnect to their WorkSpaces without re-entering their credentials.
     * @see ReconnectEnum
     */
    public final String reconnectEnabledAsString() {
        return reconnectEnabled;
    }

    /**
     * <p>
     * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to
     * troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces
     * automatically and will be applied to all users in the specified directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logUploadEnabled}
     * will return {@link LogUploadEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logUploadEnabledAsString}.
     * </p>
     * 
     * @return Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to
     *         WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be
     *         sent to WorkSpaces automatically and will be applied to all users in the specified directory.
     * @see LogUploadEnum
     */
    public final LogUploadEnum logUploadEnabled() {
        return LogUploadEnum.fromValue(logUploadEnabled);
    }

    /**
     * <p>
     * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to
     * troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces
     * automatically and will be applied to all users in the specified directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logUploadEnabled}
     * will return {@link LogUploadEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logUploadEnabledAsString}.
     * </p>
     * 
     * @return Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to
     *         WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be
     *         sent to WorkSpaces automatically and will be applied to all users in the specified directory.
     * @see LogUploadEnum
     */
    public final String logUploadEnabledAsString() {
        return logUploadEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reconnectEnabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logUploadEnabledAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientProperties)) {
            return false;
        }
        ClientProperties other = (ClientProperties) obj;
        return Objects.equals(reconnectEnabledAsString(), other.reconnectEnabledAsString())
                && Objects.equals(logUploadEnabledAsString(), other.logUploadEnabledAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientProperties").add("ReconnectEnabled", reconnectEnabledAsString())
                .add("LogUploadEnabled", logUploadEnabledAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReconnectEnabled":
            return Optional.ofNullable(clazz.cast(reconnectEnabledAsString()));
        case "LogUploadEnabled":
            return Optional.ofNullable(clazz.cast(logUploadEnabledAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientProperties, T> g) {
        return obj -> g.apply((ClientProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientProperties> {
        /**
         * <p>
         * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can
         * choose to reconnect to their WorkSpaces without re-entering their credentials.
         * </p>
         * 
         * @param reconnectEnabled
         *        Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled,
         *        users can choose to reconnect to their WorkSpaces without re-entering their credentials.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder reconnectEnabled(String reconnectEnabled);

        /**
         * <p>
         * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can
         * choose to reconnect to their WorkSpaces without re-entering their credentials.
         * </p>
         * 
         * @param reconnectEnabled
         *        Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled,
         *        users can choose to reconnect to their WorkSpaces without re-entering their credentials.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder reconnectEnabled(ReconnectEnum reconnectEnabled);

        /**
         * <p>
         * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to
         * troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces
         * automatically and will be applied to all users in the specified directory.
         * </p>
         * 
         * @param logUploadEnabled
         *        Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to
         *        WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will
         *        be sent to WorkSpaces automatically and will be applied to all users in the specified directory.
         * @see LogUploadEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogUploadEnum
         */
        Builder logUploadEnabled(String logUploadEnabled);

        /**
         * <p>
         * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to
         * troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces
         * automatically and will be applied to all users in the specified directory.
         * </p>
         * 
         * @param logUploadEnabled
         *        Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to
         *        WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will
         *        be sent to WorkSpaces automatically and will be applied to all users in the specified directory.
         * @see LogUploadEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogUploadEnum
         */
        Builder logUploadEnabled(LogUploadEnum logUploadEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String reconnectEnabled;

        private String logUploadEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientProperties model) {
            reconnectEnabled(model.reconnectEnabled);
            logUploadEnabled(model.logUploadEnabled);
        }

        public final String getReconnectEnabled() {
            return reconnectEnabled;
        }

        public final void setReconnectEnabled(String reconnectEnabled) {
            this.reconnectEnabled = reconnectEnabled;
        }

        @Override
        public final Builder reconnectEnabled(String reconnectEnabled) {
            this.reconnectEnabled = reconnectEnabled;
            return this;
        }

        @Override
        public final Builder reconnectEnabled(ReconnectEnum reconnectEnabled) {
            this.reconnectEnabled(reconnectEnabled == null ? null : reconnectEnabled.toString());
            return this;
        }

        public final String getLogUploadEnabled() {
            return logUploadEnabled;
        }

        public final void setLogUploadEnabled(String logUploadEnabled) {
            this.logUploadEnabled = logUploadEnabled;
        }

        @Override
        public final Builder logUploadEnabled(String logUploadEnabled) {
            this.logUploadEnabled = logUploadEnabled;
            return this;
        }

        @Override
        public final Builder logUploadEnabled(LogUploadEnum logUploadEnabled) {
            this.logUploadEnabled(logUploadEnabled == null ? null : logUploadEnabled.toString());
            return this;
        }

        @Override
        public ClientProperties build() {
            return new ClientProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
