/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.EntityState;
import software.amazon.awssdk.services.workmail.model.MemberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Member.getter(Member::id)).setter(Member.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Member.getter(Member::name)).setter(Member.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Member.getter(Member::typeAsString)).setter(Member.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Member.getter(Member::stateAsString)).setter(Member.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnabledDate").getter(Member.getter(Member::enabledDate)).setter(Member.setter(Builder::enabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()}).build();
    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisabledDate").getter(Member.getter(Member::disabledDate)).setter(Member.setter(Builder::disabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, TYPE_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String type;
    private final String state;
    private final Instant enabledDate;
    private final Instant disabledDate;

    private Member(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final MemberType type() {
        return MemberType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final EntityState state() {
        return EntityState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant enabledDate() {
        return this.enabledDate;
    }

    public final Instant disabledDate() {
        return this.disabledDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.enabledDate(), other.enabledDate()) && Objects.equals(this.disabledDate(), other.disabledDate());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("EnabledDate", (Object)this.enabledDate()).add("DisabledDate", (Object)this.disabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "EnabledDate": {
                return Optional.ofNullable(clazz.cast(this.enabledDate()));
            }
            case "DisabledDate": {
                return Optional.ofNullable(clazz.cast(this.disabledDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String type;
        private String state;
        private Instant enabledDate;
        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.id(model.id);
            this.name(model.name);
            this.type(model.type);
            this.state(model.state);
            this.enabledDate(model.enabledDate);
            this.disabledDate(model.disabledDate);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MemberType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getEnabledDate() {
            return this.enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        public final Instant getDisabledDate() {
            return this.disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(MemberType var1);

        public Builder state(String var1);

        public Builder state(EntityState var1);

        public Builder enabledDate(Instant var1);

        public Builder disabledDate(Instant var1);
    }
}

