/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;

public class DescribeGroupsPublisher
implements SdkPublisher<DescribeGroupsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGroupsPublisher(WorkDocsAsyncClient client, DescribeGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGroupsPublisher(WorkDocsAsyncClient client, DescribeGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupMetadata> groups() {
        Function<DescribeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeGroupsResponse> {
        private DescribeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeGroupsResponse> nextPage(DescribeGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGroupsPublisher.this.client.describeGroups(DescribeGroupsPublisher.this.firstRequest);
            }
            return DescribeGroupsPublisher.this.client.describeGroups((DescribeGroupsRequest)((Object)DescribeGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

