/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters results based on timestamp range (in epochs).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateRangeType implements SdkPojo, Serializable, ToCopyableBuilder<DateRangeType.Builder, DateRangeType> {
    private static final SdkField<Instant> START_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartValue").getter(getter(DateRangeType::startValue)).setter(setter(Builder::startValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()).build();

    private static final SdkField<Instant> END_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndValue").getter(getter(DateRangeType::endValue)).setter(setter(Builder::endValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_VALUE_FIELD,
            END_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startValue;

    private final Instant endValue;

    private DateRangeType(BuilderImpl builder) {
        this.startValue = builder.startValue;
        this.endValue = builder.endValue;
    }

    /**
     * <p>
     * Timestamp range start value (in epochs)
     * </p>
     * 
     * @return Timestamp range start value (in epochs)
     */
    public final Instant startValue() {
        return startValue;
    }

    /**
     * <p>
     * Timestamp range end value (in epochs).
     * </p>
     * 
     * @return Timestamp range end value (in epochs).
     */
    public final Instant endValue() {
        return endValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startValue());
        hashCode = 31 * hashCode + Objects.hashCode(endValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRangeType)) {
            return false;
        }
        DateRangeType other = (DateRangeType) obj;
        return Objects.equals(startValue(), other.startValue()) && Objects.equals(endValue(), other.endValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateRangeType").add("StartValue", startValue()).add("EndValue", endValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartValue":
            return Optional.ofNullable(clazz.cast(startValue()));
        case "EndValue":
            return Optional.ofNullable(clazz.cast(endValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateRangeType, T> g) {
        return obj -> g.apply((DateRangeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateRangeType> {
        /**
         * <p>
         * Timestamp range start value (in epochs)
         * </p>
         * 
         * @param startValue
         *        Timestamp range start value (in epochs)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startValue(Instant startValue);

        /**
         * <p>
         * Timestamp range end value (in epochs).
         * </p>
         * 
         * @param endValue
         *        Timestamp range end value (in epochs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endValue(Instant endValue);
    }

    static final class BuilderImpl implements Builder {
        private Instant startValue;

        private Instant endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRangeType model) {
            startValue(model.startValue);
            endValue(model.endValue);
        }

        public final Instant getStartValue() {
            return startValue;
        }

        public final void setStartValue(Instant startValue) {
            this.startValue = startValue;
        }

        @Override
        public final Builder startValue(Instant startValue) {
            this.startValue = startValue;
            return this;
        }

        public final Instant getEndValue() {
            return endValue;
        }

        public final void setEndValue(Instant endValue) {
            this.endValue = endValue;
        }

        @Override
        public final Builder endValue(Instant endValue) {
            this.endValue = endValue;
            return this;
        }

        @Override
        public DateRangeType build() {
            return new DateRangeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
