/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFolderRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, UpdateFolderRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(UpdateFolderRequest.getter(UpdateFolderRequest::authenticationToken)).setter(UpdateFolderRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderId").getter(UpdateFolderRequest.getter(UpdateFolderRequest::folderId)).setter(UpdateFolderRequest.setter(Builder::folderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateFolderRequest.getter(UpdateFolderRequest::name)).setter(UpdateFolderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentFolderId").getter(UpdateFolderRequest.getter(UpdateFolderRequest::parentFolderId)).setter(UpdateFolderRequest.setter(Builder::parentFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()}).build();
    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceState").getter(UpdateFolderRequest.getter(UpdateFolderRequest::resourceStateAsString)).setter(UpdateFolderRequest.setter(Builder::resourceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, FOLDER_ID_FIELD, NAME_FIELD, PARENT_FOLDER_ID_FIELD, RESOURCE_STATE_FIELD));
    private final String authenticationToken;
    private final String folderId;
    private final String name;
    private final String parentFolderId;
    private final String resourceState;

    private UpdateFolderRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.name = builder.name;
        this.parentFolderId = builder.parentFolderId;
        this.resourceState = builder.resourceState;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String folderId() {
        return this.folderId;
    }

    public final String name() {
        return this.name;
    }

    public final String parentFolderId() {
        return this.parentFolderId;
    }

    public final ResourceStateType resourceState() {
        return ResourceStateType.fromValue(this.resourceState);
    }

    public final String resourceStateAsString() {
        return this.resourceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFolderRequest)) {
            return false;
        }
        UpdateFolderRequest other = (UpdateFolderRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parentFolderId(), other.parentFolderId()) && Objects.equals(this.resourceStateAsString(), other.resourceStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFolderRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("FolderId", (Object)this.folderId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ParentFolderId", (Object)this.parentFolderId()).add("ResourceState", (Object)this.resourceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ParentFolderId": {
                return Optional.ofNullable(clazz.cast(this.parentFolderId()));
            }
            case "ResourceState": {
                return Optional.ofNullable(clazz.cast(this.resourceStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFolderRequest, T> g) {
        return obj -> g.apply((UpdateFolderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private String name;
        private String parentFolderId;
        private String resourceState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFolderRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.name(model.name);
            this.parentFolderId(model.parentFolderId);
            this.resourceState(model.resourceState);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFolderRequest build() {
            return new UpdateFolderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFolderRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder name(String var1);

        public Builder parentFolderId(String var1);

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

