/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateSharesRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<ListTemplateSharesRequest.Builder, ListTemplateSharesRequest> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(ListTemplateSharesRequest::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final SdkField<String> SHARED_WITH_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedWithPrefix").getter(getter(ListTemplateSharesRequest::sharedWithPrefix))
            .setter(setter(Builder::sharedWithPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SharedWithPrefix").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTemplateSharesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTemplateSharesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListTemplateSharesRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            SHARED_WITH_PREFIX_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));

    private final String templateArn;

    private final String sharedWithPrefix;

    private final String nextToken;

    private final Integer maxResults;

    private final String status;

    private ListTemplateSharesRequest(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.sharedWithPrefix = builder.sharedWithPrefix;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the profile is
     * shared.
     * </p>
     * 
     * @return The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the
     *         profile is shared.
     */
    public final String sharedWithPrefix() {
        return sharedWithPrefix;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @return The maximum number of results to return for this request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(sharedWithPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateSharesRequest)) {
            return false;
        }
        ListTemplateSharesRequest other = (ListTemplateSharesRequest) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(sharedWithPrefix(), other.sharedWithPrefix())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplateSharesRequest").add("TemplateArn", templateArn())
                .add("SharedWithPrefix", sharedWithPrefix()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "SharedWithPrefix":
            return Optional.ofNullable(clazz.cast(sharedWithPrefix()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateSharesRequest, T> g) {
        return obj -> g.apply((ListTemplateSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplateSharesRequest> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the profile is
         * shared.
         * </p>
         * 
         * @param sharedWithPrefix
         *        The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the
         *        profile is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedWithPrefix(String sharedWithPrefix);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String templateArn;

        private String sharedWithPrefix;

        private String nextToken;

        private Integer maxResults;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateSharesRequest model) {
            super(model);
            templateArn(model.templateArn);
            sharedWithPrefix(model.sharedWithPrefix);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            status(model.status);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getSharedWithPrefix() {
            return sharedWithPrefix;
        }

        public final void setSharedWithPrefix(String sharedWithPrefix) {
            this.sharedWithPrefix = sharedWithPrefix;
        }

        @Override
        public final Builder sharedWithPrefix(String sharedWithPrefix) {
            this.sharedWithPrefix = sharedWithPrefix;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTemplateSharesRequest build() {
            return new ListTemplateSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
