/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReviewTemplateAnswersResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListReviewTemplateAnswersResponse.Builder, ListReviewTemplateAnswersResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(ListReviewTemplateAnswersResponse::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(ListReviewTemplateAnswersResponse::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<List<ReviewTemplateAnswerSummary>> ANSWER_SUMMARIES_FIELD = SdkField
            .<List<ReviewTemplateAnswerSummary>> builder(MarshallingType.LIST)
            .memberName("AnswerSummaries")
            .getter(getter(ListReviewTemplateAnswersResponse::answerSummaries))
            .setter(setter(Builder::answerSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReviewTemplateAnswerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReviewTemplateAnswerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReviewTemplateAnswersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            LENS_ALIAS_FIELD, ANSWER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String templateArn;

    private final String lensAlias;

    private final List<ReviewTemplateAnswerSummary> answerSummaries;

    private final String nextToken;

    private ListReviewTemplateAnswersResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.lensAlias = builder.lensAlias;
        this.answerSummaries = builder.answerSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the review template.
     * </p>
     * 
     * @return The ARN of the review template.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnswerSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnswerSummaries() {
        return answerSummaries != null && !(answerSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of answer summaries of a lens review in a review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswerSummaries} method.
     * </p>
     * 
     * @return List of answer summaries of a lens review in a review template.
     */
    public final List<ReviewTemplateAnswerSummary> answerSummaries() {
        return answerSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswerSummaries() ? answerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewTemplateAnswersResponse)) {
            return false;
        }
        ListReviewTemplateAnswersResponse other = (ListReviewTemplateAnswersResponse) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(lensAlias(), other.lensAlias())
                && hasAnswerSummaries() == other.hasAnswerSummaries()
                && Objects.equals(answerSummaries(), other.answerSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReviewTemplateAnswersResponse").add("TemplateArn", templateArn())
                .add("LensAlias", lensAlias()).add("AnswerSummaries", hasAnswerSummaries() ? answerSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "AnswerSummaries":
            return Optional.ofNullable(clazz.cast(answerSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewTemplateAnswersResponse, T> g) {
        return obj -> g.apply((ListReviewTemplateAnswersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReviewTemplateAnswersResponse> {
        /**
         * <p>
         * The ARN of the review template.
         * </p>
         * 
         * @param templateArn
         *        The ARN of the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * List of answer summaries of a lens review in a review template.
         * </p>
         * 
         * @param answerSummaries
         *        List of answer summaries of a lens review in a review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerSummaries(Collection<ReviewTemplateAnswerSummary> answerSummaries);

        /**
         * <p>
         * List of answer summaries of a lens review in a review template.
         * </p>
         * 
         * @param answerSummaries
         *        List of answer summaries of a lens review in a review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerSummaries(ReviewTemplateAnswerSummary... answerSummaries);

        /**
         * <p>
         * List of answer summaries of a lens review in a review template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #answerSummaries(List<ReviewTemplateAnswerSummary>)}.
         * 
         * @param answerSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerSummaries(java.util.Collection<ReviewTemplateAnswerSummary>)
         */
        Builder answerSummaries(Consumer<ReviewTemplateAnswerSummary.Builder>... answerSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String templateArn;

        private String lensAlias;

        private List<ReviewTemplateAnswerSummary> answerSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewTemplateAnswersResponse model) {
            super(model);
            templateArn(model.templateArn);
            lensAlias(model.lensAlias);
            answerSummaries(model.answerSummaries);
            nextToken(model.nextToken);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final List<ReviewTemplateAnswerSummary.Builder> getAnswerSummaries() {
            List<ReviewTemplateAnswerSummary.Builder> result = ReviewTemplateAnswerSummariesCopier
                    .copyToBuilder(this.answerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnswerSummaries(Collection<ReviewTemplateAnswerSummary.BuilderImpl> answerSummaries) {
            this.answerSummaries = ReviewTemplateAnswerSummariesCopier.copyFromBuilder(answerSummaries);
        }

        @Override
        public final Builder answerSummaries(Collection<ReviewTemplateAnswerSummary> answerSummaries) {
            this.answerSummaries = ReviewTemplateAnswerSummariesCopier.copy(answerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(ReviewTemplateAnswerSummary... answerSummaries) {
            answerSummaries(Arrays.asList(answerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(Consumer<ReviewTemplateAnswerSummary.Builder>... answerSummaries) {
            answerSummaries(Stream.of(answerSummaries).map(c -> ReviewTemplateAnswerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReviewTemplateAnswersResponse build() {
            return new ListReviewTemplateAnswersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
