/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLensVersionRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, CreateLensVersionRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(CreateLensVersionRequest.getter(CreateLensVersionRequest::lensAlias)).setter(CreateLensVersionRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(CreateLensVersionRequest.getter(CreateLensVersionRequest::lensVersion)).setter(CreateLensVersionRequest.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<Boolean> IS_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMajorVersion").getter(CreateLensVersionRequest.getter(CreateLensVersionRequest::isMajorVersion)).setter(CreateLensVersionRequest.setter(Builder::isMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMajorVersion").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateLensVersionRequest.getter(CreateLensVersionRequest::clientRequestToken)).setter(CreateLensVersionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_VERSION_FIELD, IS_MAJOR_VERSION_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String lensAlias;
    private final String lensVersion;
    private final Boolean isMajorVersion;
    private final String clientRequestToken;

    private CreateLensVersionRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.lensVersion = builder.lensVersion;
        this.isMajorVersion = builder.isMajorVersion;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final Boolean isMajorVersion() {
        return this.isMajorVersion;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLensVersionRequest)) {
            return false;
        }
        CreateLensVersionRequest other = (CreateLensVersionRequest)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.isMajorVersion(), other.isMajorVersion()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLensVersionRequest").add("LensAlias", (Object)this.lensAlias()).add("LensVersion", (Object)this.lensVersion()).add("IsMajorVersion", (Object)this.isMajorVersion()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "IsMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.isMajorVersion()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLensVersionRequest, T> g) {
        return obj -> g.apply((CreateLensVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensVersion;
        private Boolean isMajorVersion;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLensVersionRequest model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.lensVersion(model.lensVersion);
            this.isMajorVersion(model.isMajorVersion);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final Boolean getIsMajorVersion() {
            return this.isMajorVersion;
        }

        public final void setIsMajorVersion(Boolean isMajorVersion) {
            this.isMajorVersion = isMajorVersion;
        }

        @Override
        public final Builder isMajorVersion(Boolean isMajorVersion) {
            this.isMajorVersion = isMajorVersion;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLensVersionRequest build() {
            return new CreateLensVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLensVersionRequest> {
        public Builder lensAlias(String var1);

        public Builder lensVersion(String var1);

        public Builder isMajorVersion(Boolean var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

