/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wellarchitected.DefaultWellArchitectedBaseClientBuilder;
import software.amazon.awssdk.services.wellarchitected.DefaultWellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClientBuilder;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedServiceClientConfiguration;
import software.amazon.awssdk.services.wellarchitected.endpoints.WellArchitectedEndpointProvider;

@SdkInternalApi
final class DefaultWellArchitectedClientBuilder
extends DefaultWellArchitectedBaseClientBuilder<WellArchitectedClientBuilder, WellArchitectedClient>
implements WellArchitectedClientBuilder {
    DefaultWellArchitectedClientBuilder() {
    }

    @Override
    public DefaultWellArchitectedClientBuilder endpointProvider(WellArchitectedEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WellArchitectedClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWellArchitectedClientBuilder.validateClientOptions(clientConfiguration);
        WellArchitectedServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWellArchitectedClient client = new DefaultWellArchitectedClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WellArchitectedServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WellArchitectedServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

