/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LensType {
    AWS_OFFICIAL("AWS_OFFICIAL"),
    CUSTOM_SHARED("CUSTOM_SHARED"),
    CUSTOM_SELF("CUSTOM_SELF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LensType> VALUE_MAP;
    private final String value;

    private LensType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LensType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LensType> knownValues() {
        EnumSet<LensType> knownValues = EnumSet.allOf(LensType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LensType.class, LensType::toString);
    }
}

