/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.CheckDetail;
import software.amazon.awssdk.services.wellarchitected.model.CheckDetailsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCheckDetailsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListCheckDetailsResponse> {
    private static final SdkField<List<CheckDetail>> CHECK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckDetails").getter(ListCheckDetailsResponse.getter(ListCheckDetailsResponse::checkDetails)).setter(ListCheckDetailsResponse.setter(Builder::checkDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CheckDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCheckDetailsResponse.getter(ListCheckDetailsResponse::nextToken)).setter(ListCheckDetailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CheckDetail> checkDetails;
    private final String nextToken;

    private ListCheckDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.checkDetails = builder.checkDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCheckDetails() {
        return this.checkDetails != null && !(this.checkDetails instanceof SdkAutoConstructList);
    }

    public final List<CheckDetail> checkDetails() {
        return this.checkDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckDetails() ? this.checkDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCheckDetailsResponse)) {
            return false;
        }
        ListCheckDetailsResponse other = (ListCheckDetailsResponse)((Object)obj);
        return this.hasCheckDetails() == other.hasCheckDetails() && Objects.equals(this.checkDetails(), other.checkDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCheckDetailsResponse").add("CheckDetails", this.hasCheckDetails() ? this.checkDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckDetails": {
                return Optional.ofNullable(clazz.cast(this.checkDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCheckDetailsResponse, T> g) {
        return obj -> g.apply((ListCheckDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<CheckDetail> checkDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCheckDetailsResponse model) {
            super(model);
            this.checkDetails(model.checkDetails);
            this.nextToken(model.nextToken);
        }

        public final List<CheckDetail.Builder> getCheckDetails() {
            List<CheckDetail.Builder> result = CheckDetailsCopier.copyToBuilder(this.checkDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckDetails(Collection<CheckDetail.BuilderImpl> checkDetails) {
            this.checkDetails = CheckDetailsCopier.copyFromBuilder(checkDetails);
        }

        @Override
        public final Builder checkDetails(Collection<CheckDetail> checkDetails) {
            this.checkDetails = CheckDetailsCopier.copy(checkDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkDetails(CheckDetail ... checkDetails) {
            this.checkDetails(Arrays.asList(checkDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkDetails(Consumer<CheckDetail.Builder> ... checkDetails) {
            this.checkDetails(Stream.of(checkDetails).map(c -> (CheckDetail)((CheckDetail.Builder)CheckDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCheckDetailsResponse build() {
            return new ListCheckDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCheckDetailsResponse> {
        public Builder checkDetails(Collection<CheckDetail> var1);

        public Builder checkDetails(CheckDetail ... var1);

        public Builder checkDetails(Consumer<CheckDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

