/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableManagedRuleGroupVersionsRequest extends Wafv2Request implements
        ToCopyableBuilder<ListAvailableManagedRuleGroupVersionsRequest.Builder, ListAvailableManagedRuleGroupVersionsRequest> {
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorName").getter(getter(ListAvailableManagedRuleGroupVersionsRequest::vendorName))
            .setter(setter(Builder::vendorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListAvailableManagedRuleGroupVersionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(ListAvailableManagedRuleGroupVersionsRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListAvailableManagedRuleGroupVersionsRequest::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListAvailableManagedRuleGroupVersionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_NAME_FIELD, NAME_FIELD,
            SCOPE_FIELD, NEXT_MARKER_FIELD, LIMIT_FIELD));

    private final String vendorName;

    private final String name;

    private final String scope;

    private final String nextMarker;

    private final Integer limit;

    private ListAvailableManagedRuleGroupVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.vendorName = builder.vendorName;
        this.name = builder.name;
        this.scope = builder.scope;
        this.nextMarker = builder.nextMarker;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
     * group.
     * </p>
     * 
     * @return The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
     *         rule group.
     */
    public final String vendorName() {
        return vendorName;
    }

    /**
     * <p>
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     * </p>
     * 
     * @return The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an
     * Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
     *         API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access
     *         instance. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an
     * Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
     *         API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access
     *         instance. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of objects that you want WAF to return for this request. If more objects are available, in the
     * response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next
     * batch of objects.
     * </p>
     * 
     * @return The maximum number of objects that you want WAF to return for this request. If more objects are
     *         available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent
     *         call to get the next batch of objects.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableManagedRuleGroupVersionsRequest)) {
            return false;
        }
        ListAvailableManagedRuleGroupVersionsRequest other = (ListAvailableManagedRuleGroupVersionsRequest) obj;
        return Objects.equals(vendorName(), other.vendorName()) && Objects.equals(name(), other.name())
                && Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableManagedRuleGroupVersionsRequest").add("VendorName", vendorName())
                .add("Name", name()).add("Scope", scopeAsString()).add("NextMarker", nextMarker()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VendorName":
            return Optional.ofNullable(clazz.cast(vendorName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableManagedRuleGroupVersionsRequest, T> g) {
        return obj -> g.apply((ListAvailableManagedRuleGroupVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableManagedRuleGroupVersionsRequest> {
        /**
         * <p>
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
         * group.
         * </p>
         * 
         * @param vendorName
         *        The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
         *        rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorName(String vendorName);

        /**
         * <p>
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         * </p>
         * 
         * @param name
         *        The name of the managed rule group. You use this, along with the vendor name, to identify the rule
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
         * API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an
         *        AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services
         *        Verified Access instance. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
         * API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an
         *        AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services
         *        Verified Access instance. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
         * retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in
         *        the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of objects that you want WAF to return for this request. If more objects are available, in
         * the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the
         * next batch of objects.
         * </p>
         * 
         * @param limit
         *        The maximum number of objects that you want WAF to return for this request. If more objects are
         *        available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a
         *        subsequent call to get the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String vendorName;

        private String name;

        private String scope;

        private String nextMarker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableManagedRuleGroupVersionsRequest model) {
            super(model);
            vendorName(model.vendorName);
            name(model.name);
            scope(model.scope);
            nextMarker(model.nextMarker);
            limit(model.limit);
        }

        public final String getVendorName() {
            return vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAvailableManagedRuleGroupVersionsRequest build() {
            return new ListAvailableManagedRuleGroupVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
