/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for your use of the account creation fraud prevention managed rule group,
 * <code>AWSManagedRulesACFPRuleSet</code>. This configuration is used in <code>ManagedRuleGroupConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AWSManagedRulesACFPRuleSet implements SdkPojo, Serializable,
        ToCopyableBuilder<AWSManagedRulesACFPRuleSet.Builder, AWSManagedRulesACFPRuleSet> {
    private static final SdkField<String> CREATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationPath").getter(getter(AWSManagedRulesACFPRuleSet::creationPath))
            .setter(setter(Builder::creationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationPath").build()).build();

    private static final SdkField<String> REGISTRATION_PAGE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationPagePath").getter(getter(AWSManagedRulesACFPRuleSet::registrationPagePath))
            .setter(setter(Builder::registrationPagePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationPagePath").build())
            .build();

    private static final SdkField<RequestInspectionACFP> REQUEST_INSPECTION_FIELD = SdkField
            .<RequestInspectionACFP> builder(MarshallingType.SDK_POJO).memberName("RequestInspection")
            .getter(getter(AWSManagedRulesACFPRuleSet::requestInspection)).setter(setter(Builder::requestInspection))
            .constructor(RequestInspectionACFP::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestInspection").build()).build();

    private static final SdkField<ResponseInspection> RESPONSE_INSPECTION_FIELD = SdkField
            .<ResponseInspection> builder(MarshallingType.SDK_POJO).memberName("ResponseInspection")
            .getter(getter(AWSManagedRulesACFPRuleSet::responseInspection)).setter(setter(Builder::responseInspection))
            .constructor(ResponseInspection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseInspection").build())
            .build();

    private static final SdkField<Boolean> ENABLE_REGEX_IN_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableRegexInPath").getter(getter(AWSManagedRulesACFPRuleSet::enableRegexInPath))
            .setter(setter(Builder::enableRegexInPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableRegexInPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_PATH_FIELD,
            REGISTRATION_PAGE_PATH_FIELD, REQUEST_INSPECTION_FIELD, RESPONSE_INSPECTION_FIELD, ENABLE_REGEX_IN_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creationPath;

    private final String registrationPagePath;

    private final RequestInspectionACFP requestInspection;

    private final ResponseInspection responseInspection;

    private final Boolean enableRegexInPath;

    private AWSManagedRulesACFPRuleSet(BuilderImpl builder) {
        this.creationPath = builder.creationPath;
        this.registrationPagePath = builder.registrationPagePath;
        this.requestInspection = builder.requestInspection;
        this.responseInspection = builder.responseInspection;
        this.enableRegexInPath = builder.enableRegexInPath;
    }

    /**
     * <p>
     * The path of the account creation endpoint for your application. This is the page on your website that accepts the
     * completed registration form for a new user. This page must accept <code>POST</code> requests.
     * </p>
     * <p>
     * For example, for the URL <code>https://example.com/web/newaccount</code>, you would provide the path
     * <code>/web/newaccount</code>. Account creation page paths that start with the path that you provide are
     * considered a match. For example <code>/web/newaccount</code> matches the account creation paths
     * <code>/web/newaccount</code>, <code>/web/newaccount/</code>, <code>/web/newaccountPage</code>, and
     * <code>/web/newaccount/thisPage</code>, but doesn't match the path <code>/home/web/newaccount</code> or
     * <code>/website/newaccount</code>.
     * </p>
     * 
     * @return The path of the account creation endpoint for your application. This is the page on your website that
     *         accepts the completed registration form for a new user. This page must accept <code>POST</code>
     *         requests.</p>
     *         <p>
     *         For example, for the URL <code>https://example.com/web/newaccount</code>, you would provide the path
     *         <code>/web/newaccount</code>. Account creation page paths that start with the path that you provide are
     *         considered a match. For example <code>/web/newaccount</code> matches the account creation paths
     *         <code>/web/newaccount</code>, <code>/web/newaccount/</code>, <code>/web/newaccountPage</code>, and
     *         <code>/web/newaccount/thisPage</code>, but doesn't match the path <code>/home/web/newaccount</code> or
     *         <code>/website/newaccount</code>.
     */
    public final String creationPath() {
        return creationPath;
    }

    /**
     * <p>
     * The path of the account registration endpoint for your application. This is the page on your website that
     * presents the registration form to new users.
     * </p>
     * <note>
     * <p>
     * This page must accept <code>GET</code> text/html requests.
     * </p>
     * </note>
     * <p>
     * For example, for the URL <code>https://example.com/web/registration</code>, you would provide the path
     * <code>/web/registration</code>. Registration page paths that start with the path that you provide are considered
     * a match. For example <code>/web/registration</code> matches the registration paths <code>/web/registration</code>, <code>/web/registration/</code>, <code>/web/registrationPage</code>, and
     * <code>/web/registration/thisPage</code>, but doesn't match the path <code>/home/web/registration</code> or
     * <code>/website/registration</code>.
     * </p>
     * 
     * @return The path of the account registration endpoint for your application. This is the page on your website that
     *         presents the registration form to new users. </p> <note>
     *         <p>
     *         This page must accept <code>GET</code> text/html requests.
     *         </p>
     *         </note>
     *         <p>
     *         For example, for the URL <code>https://example.com/web/registration</code>, you would provide the path
     *         <code>/web/registration</code>. Registration page paths that start with the path that you provide are
     *         considered a match. For example <code>/web/registration</code> matches the registration paths
     *         <code>/web/registration</code>, <code>/web/registration/</code>, <code>/web/registrationPage</code>, and
     *         <code>/web/registration/thisPage</code>, but doesn't match the path <code>/home/web/registration</code>
     *         or <code>/website/registration</code>.
     */
    public final String registrationPagePath() {
        return registrationPagePath;
    }

    /**
     * <p>
     * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account
     * creation attempts.
     * </p>
     * 
     * @return The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track
     *         account creation attempts.
     */
    public final RequestInspectionACFP requestInspection() {
        return requestInspection;
    }

    /**
     * <p>
     * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account
     * creation success rates.
     * </p>
     * <note>
     * <p>
     * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     * </p>
     * </note>
     * <p>
     * The ACFP rule group evaluates the responses that your protected resources send back to client account creation
     * attempts, keeping count of successful and failed attempts from each IP address and client session. Using this
     * information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too
     * many successful account creation attempts in a short amount of time.
     * </p>
     * 
     * @return The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track
     *         account creation success rates. </p> <note>
     *         <p>
     *         Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     *         </p>
     *         </note>
     *         <p>
     *         The ACFP rule group evaluates the responses that your protected resources send back to client account
     *         creation attempts, keeping count of successful and failed attempts from each IP address and client
     *         session. Using this information, the rule group labels and mitigates requests from client sessions and IP
     *         addresses that have had too many successful account creation attempts in a short amount of time.
     */
    public final ResponseInspection responseInspection() {
        return responseInspection;
    }

    /**
     * <p>
     * Allow the use of regular expressions in the registration page path and the account creation path.
     * </p>
     * 
     * @return Allow the use of regular expressions in the registration page path and the account creation path.
     */
    public final Boolean enableRegexInPath() {
        return enableRegexInPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationPath());
        hashCode = 31 * hashCode + Objects.hashCode(registrationPagePath());
        hashCode = 31 * hashCode + Objects.hashCode(requestInspection());
        hashCode = 31 * hashCode + Objects.hashCode(responseInspection());
        hashCode = 31 * hashCode + Objects.hashCode(enableRegexInPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesACFPRuleSet)) {
            return false;
        }
        AWSManagedRulesACFPRuleSet other = (AWSManagedRulesACFPRuleSet) obj;
        return Objects.equals(creationPath(), other.creationPath())
                && Objects.equals(registrationPagePath(), other.registrationPagePath())
                && Objects.equals(requestInspection(), other.requestInspection())
                && Objects.equals(responseInspection(), other.responseInspection())
                && Objects.equals(enableRegexInPath(), other.enableRegexInPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AWSManagedRulesACFPRuleSet").add("CreationPath", creationPath())
                .add("RegistrationPagePath", registrationPagePath()).add("RequestInspection", requestInspection())
                .add("ResponseInspection", responseInspection()).add("EnableRegexInPath", enableRegexInPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationPath":
            return Optional.ofNullable(clazz.cast(creationPath()));
        case "RegistrationPagePath":
            return Optional.ofNullable(clazz.cast(registrationPagePath()));
        case "RequestInspection":
            return Optional.ofNullable(clazz.cast(requestInspection()));
        case "ResponseInspection":
            return Optional.ofNullable(clazz.cast(responseInspection()));
        case "EnableRegexInPath":
            return Optional.ofNullable(clazz.cast(enableRegexInPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesACFPRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesACFPRuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AWSManagedRulesACFPRuleSet> {
        /**
         * <p>
         * The path of the account creation endpoint for your application. This is the page on your website that accepts
         * the completed registration form for a new user. This page must accept <code>POST</code> requests.
         * </p>
         * <p>
         * For example, for the URL <code>https://example.com/web/newaccount</code>, you would provide the path
         * <code>/web/newaccount</code>. Account creation page paths that start with the path that you provide are
         * considered a match. For example <code>/web/newaccount</code> matches the account creation paths
         * <code>/web/newaccount</code>, <code>/web/newaccount/</code>, <code>/web/newaccountPage</code>, and
         * <code>/web/newaccount/thisPage</code>, but doesn't match the path <code>/home/web/newaccount</code> or
         * <code>/website/newaccount</code>.
         * </p>
         * 
         * @param creationPath
         *        The path of the account creation endpoint for your application. This is the page on your website that
         *        accepts the completed registration form for a new user. This page must accept <code>POST</code>
         *        requests.</p>
         *        <p>
         *        For example, for the URL <code>https://example.com/web/newaccount</code>, you would provide the path
         *        <code>/web/newaccount</code>. Account creation page paths that start with the path that you provide
         *        are considered a match. For example <code>/web/newaccount</code> matches the account creation paths
         *        <code>/web/newaccount</code>, <code>/web/newaccount/</code>, <code>/web/newaccountPage</code>, and
         *        <code>/web/newaccount/thisPage</code>, but doesn't match the path <code>/home/web/newaccount</code> or
         *        <code>/website/newaccount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationPath(String creationPath);

        /**
         * <p>
         * The path of the account registration endpoint for your application. This is the page on your website that
         * presents the registration form to new users.
         * </p>
         * <note>
         * <p>
         * This page must accept <code>GET</code> text/html requests.
         * </p>
         * </note>
         * <p>
         * For example, for the URL <code>https://example.com/web/registration</code>, you would provide the path
         * <code>/web/registration</code>. Registration page paths that start with the path that you provide are
         * considered a match. For example <code>/web/registration</code> matches the registration paths
         * <code>/web/registration</code>, <code>/web/registration/</code>, <code>/web/registrationPage</code>, and
         * <code>/web/registration/thisPage</code>, but doesn't match the path <code>/home/web/registration</code> or
         * <code>/website/registration</code>.
         * </p>
         * 
         * @param registrationPagePath
         *        The path of the account registration endpoint for your application. This is the page on your website
         *        that presents the registration form to new users. </p> <note>
         *        <p>
         *        This page must accept <code>GET</code> text/html requests.
         *        </p>
         *        </note>
         *        <p>
         *        For example, for the URL <code>https://example.com/web/registration</code>, you would provide the path
         *        <code>/web/registration</code>. Registration page paths that start with the path that you provide are
         *        considered a match. For example <code>/web/registration</code> matches the registration paths
         *        <code>/web/registration</code>, <code>/web/registration/</code>, <code>/web/registrationPage</code>,
         *        and <code>/web/registration/thisPage</code>, but doesn't match the path
         *        <code>/home/web/registration</code> or <code>/website/registration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationPagePath(String registrationPagePath);

        /**
         * <p>
         * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track
         * account creation attempts.
         * </p>
         * 
         * @param requestInspection
         *        The criteria for inspecting account creation requests, used by the ACFP rule group to validate and
         *        track account creation attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestInspection(RequestInspectionACFP requestInspection);

        /**
         * <p>
         * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track
         * account creation attempts.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestInspectionACFP.Builder} avoiding
         * the need to create one manually via {@link RequestInspectionACFP#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestInspectionACFP.Builder#build()} is called immediately and
         * its result is passed to {@link #requestInspection(RequestInspectionACFP)}.
         * 
         * @param requestInspection
         *        a consumer that will call methods on {@link RequestInspectionACFP.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestInspection(RequestInspectionACFP)
         */
        default Builder requestInspection(Consumer<RequestInspectionACFP.Builder> requestInspection) {
            return requestInspection(RequestInspectionACFP.builder().applyMutation(requestInspection).build());
        }

        /**
         * <p>
         * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track
         * account creation success rates.
         * </p>
         * <note>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * </p>
         * </note>
         * <p>
         * The ACFP rule group evaluates the responses that your protected resources send back to client account
         * creation attempts, keeping count of successful and failed attempts from each IP address and client session.
         * Using this information, the rule group labels and mitigates requests from client sessions and IP addresses
         * that have had too many successful account creation attempts in a short amount of time.
         * </p>
         * 
         * @param responseInspection
         *        The criteria for inspecting responses to account creation requests, used by the ACFP rule group to
         *        track account creation success rates. </p> <note>
         *        <p>
         *        Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         *        </p>
         *        </note>
         *        <p>
         *        The ACFP rule group evaluates the responses that your protected resources send back to client account
         *        creation attempts, keeping count of successful and failed attempts from each IP address and client
         *        session. Using this information, the rule group labels and mitigates requests from client sessions and
         *        IP addresses that have had too many successful account creation attempts in a short amount of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseInspection(ResponseInspection responseInspection);

        /**
         * <p>
         * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track
         * account creation success rates.
         * </p>
         * <note>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * </p>
         * </note>
         * <p>
         * The ACFP rule group evaluates the responses that your protected resources send back to client account
         * creation attempts, keeping count of successful and failed attempts from each IP address and client session.
         * Using this information, the rule group labels and mitigates requests from client sessions and IP addresses
         * that have had too many successful account creation attempts in a short amount of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseInspection.Builder} avoiding the
         * need to create one manually via {@link ResponseInspection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseInspection.Builder#build()} is called immediately and its
         * result is passed to {@link #responseInspection(ResponseInspection)}.
         * 
         * @param responseInspection
         *        a consumer that will call methods on {@link ResponseInspection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseInspection(ResponseInspection)
         */
        default Builder responseInspection(Consumer<ResponseInspection.Builder> responseInspection) {
            return responseInspection(ResponseInspection.builder().applyMutation(responseInspection).build());
        }

        /**
         * <p>
         * Allow the use of regular expressions in the registration page path and the account creation path.
         * </p>
         * 
         * @param enableRegexInPath
         *        Allow the use of regular expressions in the registration page path and the account creation path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableRegexInPath(Boolean enableRegexInPath);
    }

    static final class BuilderImpl implements Builder {
        private String creationPath;

        private String registrationPagePath;

        private RequestInspectionACFP requestInspection;

        private ResponseInspection responseInspection;

        private Boolean enableRegexInPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesACFPRuleSet model) {
            creationPath(model.creationPath);
            registrationPagePath(model.registrationPagePath);
            requestInspection(model.requestInspection);
            responseInspection(model.responseInspection);
            enableRegexInPath(model.enableRegexInPath);
        }

        public final String getCreationPath() {
            return creationPath;
        }

        public final void setCreationPath(String creationPath) {
            this.creationPath = creationPath;
        }

        @Override
        public final Builder creationPath(String creationPath) {
            this.creationPath = creationPath;
            return this;
        }

        public final String getRegistrationPagePath() {
            return registrationPagePath;
        }

        public final void setRegistrationPagePath(String registrationPagePath) {
            this.registrationPagePath = registrationPagePath;
        }

        @Override
        public final Builder registrationPagePath(String registrationPagePath) {
            this.registrationPagePath = registrationPagePath;
            return this;
        }

        public final RequestInspectionACFP.Builder getRequestInspection() {
            return requestInspection != null ? requestInspection.toBuilder() : null;
        }

        public final void setRequestInspection(RequestInspectionACFP.BuilderImpl requestInspection) {
            this.requestInspection = requestInspection != null ? requestInspection.build() : null;
        }

        @Override
        public final Builder requestInspection(RequestInspectionACFP requestInspection) {
            this.requestInspection = requestInspection;
            return this;
        }

        public final ResponseInspection.Builder getResponseInspection() {
            return responseInspection != null ? responseInspection.toBuilder() : null;
        }

        public final void setResponseInspection(ResponseInspection.BuilderImpl responseInspection) {
            this.responseInspection = responseInspection != null ? responseInspection.build() : null;
        }

        @Override
        public final Builder responseInspection(ResponseInspection responseInspection) {
            this.responseInspection = responseInspection;
            return this;
        }

        public final Boolean getEnableRegexInPath() {
            return enableRegexInPath;
        }

        public final void setEnableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
        }

        @Override
        public final Builder enableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
            return this;
        }

        @Override
        public AWSManagedRulesACFPRuleSet build() {
            return new AWSManagedRulesACFPRuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
