/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallManagerRuleGroupsRequest extends Wafv2Request implements
        ToCopyableBuilder<DeleteFirewallManagerRuleGroupsRequest.Builder, DeleteFirewallManagerRuleGroupsRequest> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLArn").getter(getter(DeleteFirewallManagerRuleGroupsRequest::webACLArn))
            .setter(setter(Builder::webACLArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn").build()).build();

    private static final SdkField<String> WEB_ACL_LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLLockToken").getter(getter(DeleteFirewallManagerRuleGroupsRequest::webACLLockToken))
            .setter(setter(Builder::webACLLockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLLockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            WEB_ACL_LOCK_TOKEN_FIELD));

    private final String webACLArn;

    private final String webACLLockToken;

    private DeleteFirewallManagerRuleGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.webACLArn = builder.webACLArn;
        this.webACLLockToken = builder.webACLLockToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web ACL.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web ACL.
     */
    public final String webACLArn() {
        return webACLArn;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String webACLLockToken() {
        return webACLLockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(webACLLockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallManagerRuleGroupsRequest)) {
            return false;
        }
        DeleteFirewallManagerRuleGroupsRequest other = (DeleteFirewallManagerRuleGroupsRequest) obj;
        return Objects.equals(webACLArn(), other.webACLArn()) && Objects.equals(webACLLockToken(), other.webACLLockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallManagerRuleGroupsRequest").add("WebACLArn", webACLArn())
                .add("WebACLLockToken", webACLLockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLArn":
            return Optional.ofNullable(clazz.cast(webACLArn()));
        case "WebACLLockToken":
            return Optional.ofNullable(clazz.cast(webACLLockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallManagerRuleGroupsRequest, T> g) {
        return obj -> g.apply((DeleteFirewallManagerRuleGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFirewallManagerRuleGroupsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web ACL.
         * </p>
         * 
         * @param webACLArn
         *        The Amazon Resource Name (ARN) of the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLArn(String webACLArn);

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param webACLLockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLLockToken(String webACLLockToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String webACLArn;

        private String webACLLockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallManagerRuleGroupsRequest model) {
            super(model);
            webACLArn(model.webACLArn);
            webACLLockToken(model.webACLLockToken);
        }

        public final String getWebACLArn() {
            return webACLArn;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final String getWebACLLockToken() {
            return webACLLockToken;
        }

        public final void setWebACLLockToken(String webACLLockToken) {
            this.webACLLockToken = webACLLockToken;
        }

        @Override
        public final Builder webACLLockToken(String webACLLockToken) {
            this.webACLLockToken = webACLLockToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFirewallManagerRuleGroupsRequest build() {
            return new DeleteFirewallManagerRuleGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
