/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<CreateRuleRequest.Builder, CreateRuleRequest> {
    private static final SdkField<RuleAction> ACTION_FIELD = SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(CreateRuleRequest::action)).setter(setter(Builder::action))
            .constructor(RuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerIdentifier").getter(getter(CreateRuleRequest::listenerIdentifier))
            .setter(setter(Builder::listenerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()).build();

    private static final SdkField<RuleMatch> MATCH_FIELD = SdkField.<RuleMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(CreateRuleRequest::match)).setter(setter(Builder::match))
            .constructor(RuleMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(CreateRuleRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(CreateRuleRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CLIENT_TOKEN_FIELD, LISTENER_IDENTIFIER_FIELD, MATCH_FIELD, NAME_FIELD, PRIORITY_FIELD, SERVICE_IDENTIFIER_FIELD,
            TAGS_FIELD));

    private final RuleAction action;

    private final String clientToken;

    private final String listenerIdentifier;

    private final RuleMatch match;

    private final String name;

    private final Integer priority;

    private final String serviceIdentifier;

    private final Map<String, String> tags;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.listenerIdentifier = builder.listenerIdentifier;
        this.match = builder.match;
        this.name = builder.name;
        this.priority = builder.priority;
        this.serviceIdentifier = builder.serviceIdentifier;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The action for the default rule.
     * </p>
     * 
     * @return The action for the default rule.
     */
    public final RuleAction action() {
        return action;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
     * request that completed successfully using the same client token and parameters, the retry succeeds without
     * performing any actions. If the parameters aren't identical, the retry fails.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         retry a request that completed successfully using the same client token and parameters, the retry
     *         succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerIdentifier() {
        return listenerIdentifier;
    }

    /**
     * <p>
     * The rule match.
     * </p>
     * 
     * @return The rule match.
     */
    public final RuleMatch match() {
        return match;
    }

    /**
     * <p>
     * The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens
     * (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     * </p>
     * 
     * @return The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and
     *         hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the
     * priority number the higher the priority.
     * </p>
     * 
     * @return The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The
     *         lower the priority number the higher the priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the rule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(listenerIdentifier(), other.listenerIdentifier()) && Objects.equals(match(), other.match())
                && Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority())
                && Objects.equals(serviceIdentifier(), other.serviceIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleRequest").add("Action", action()).add("ClientToken", clientToken())
                .add("ListenerIdentifier", listenerIdentifier()).add("Match", match()).add("Name", name())
                .add("Priority", priority()).add("ServiceIdentifier", serviceIdentifier()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "listenerIdentifier":
            return Optional.ofNullable(clazz.cast(listenerIdentifier()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleRequest> {
        /**
         * <p>
         * The action for the default rule.
         * </p>
         * 
         * @param action
         *        The action for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * The action for the default rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleAction.Builder} avoiding the need to
         * create one manually via {@link RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleAction.Builder#build()} is called immediately and its result
         * is passed to {@link #action(RuleAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(RuleAction)
         */
        default Builder action(Consumer<RuleAction.Builder> action) {
            return action(RuleAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
         * request that completed successfully using the same client token and parameters, the retry succeeds without
         * performing any actions. If the parameters aren't identical, the retry fails.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        retry a request that completed successfully using the same client token and parameters, the retry
         *        succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerIdentifier
         *        The ID or Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerIdentifier(String listenerIdentifier);

        /**
         * <p>
         * The rule match.
         * </p>
         * 
         * @param match
         *        The rule match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(RuleMatch match);

        /**
         * <p>
         * The rule match.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleMatch.Builder} avoiding the need to
         * create one manually via {@link RuleMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleMatch.Builder#build()} is called immediately and its result
         * is passed to {@link #match(RuleMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link RuleMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(RuleMatch)
         */
        default Builder match(Consumer<RuleMatch.Builder> match) {
            return match(RuleMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and
         * hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         * </p>
         * 
         * @param name
         *        The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9,
         *        and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another
         *        hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower
         * the priority number the higher the priority.
         * </p>
         * 
         * @param priority
         *        The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The
         *        lower the priority number the higher the priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        /**
         * <p>
         * The tags for the rule.
         * </p>
         * 
         * @param tags
         *        The tags for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private RuleAction action;

        private String clientToken;

        private String listenerIdentifier;

        private RuleMatch match;

        private String name;

        private Integer priority;

        private String serviceIdentifier;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            action(model.action);
            clientToken(model.clientToken);
            listenerIdentifier(model.listenerIdentifier);
            match(model.match);
            name(model.name);
            priority(model.priority);
            serviceIdentifier(model.serviceIdentifier);
            tags(model.tags);
        }

        public final RuleAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(RuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action = action;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getListenerIdentifier() {
            return listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final RuleMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(RuleMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(RuleMatch match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
