/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateListenerRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<CreateListenerRequest.Builder, CreateListenerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateListenerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<RuleAction> DEFAULT_ACTION_FIELD = SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
            .memberName("defaultAction").getter(getter(CreateListenerRequest::defaultAction))
            .setter(setter(Builder::defaultAction)).constructor(RuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAction").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateListenerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(CreateListenerRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(CreateListenerRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(CreateListenerRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateListenerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DEFAULT_ACTION_FIELD, NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, SERVICE_IDENTIFIER_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final RuleAction defaultAction;

    private final String name;

    private final Integer port;

    private final String protocol;

    private final String serviceIdentifier;

    private final Map<String, String> tags;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.defaultAction = builder.defaultAction;
        this.name = builder.name;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.serviceIdentifier = builder.serviceIdentifier;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
     * request that completed successfully using the same client token and parameters, the retry succeeds without
     * performing any actions. If the parameters aren't identical, the retry fails.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         retry a request that completed successfully using the same client token and parameters, the retry
     *         succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The action for the default rule. Each listener has a default rule. Each rule consists of a priority, one or more
     * actions, and one or more conditions. The default rule is the rule that's used if no other rules match. Each rule
     * must include exactly one of the following types of actions: <code>forward </code>or <code>fixed-response</code>,
     * and it must be the last action to be performed.
     * </p>
     * 
     * @return The action for the default rule. Each listener has a default rule. Each rule consists of a priority, one
     *         or more actions, and one or more conditions. The default rule is the rule that's used if no other rules
     *         match. Each rule must include exactly one of the following types of actions: <code>forward </code>or
     *         <code>fixed-response</code>, and it must be the last action to be performed.
     */
    public final RuleAction defaultAction() {
        return defaultAction;
    }

    /**
     * <p>
     * The name of the listener. A listener name must be unique within a service. The valid characters are a-z, 0-9, and
     * hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     * </p>
     * 
     * @return The name of the listener. A listener name must be unique within a service. The valid characters are a-z,
     *         0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another
     *         hyphen.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The listener port. You can specify a value from <code>1</code> to <code>65535</code>. For HTTP, the default is
     * <code>80</code>. For HTTPS, the default is <code>443</code>.
     * </p>
     * 
     * @return The listener port. You can specify a value from <code>1</code> to <code>65535</code>. For HTTP, the
     *         default is <code>80</code>. For HTTPS, the default is <code>443</code>.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The listener protocol HTTP or HTTPS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ListenerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The listener protocol HTTP or HTTPS.
     * @see ListenerProtocol
     */
    public final ListenerProtocol protocol() {
        return ListenerProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The listener protocol HTTP or HTTPS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ListenerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The listener protocol HTTP or HTTPS.
     * @see ListenerProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the listener.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(defaultAction(), other.defaultAction())
                && Objects.equals(name(), other.name()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(serviceIdentifier(), other.serviceIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateListenerRequest").add("ClientToken", clientToken()).add("DefaultAction", defaultAction())
                .add("Name", name()).add("Port", port()).add("Protocol", protocolAsString())
                .add("ServiceIdentifier", serviceIdentifier()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "defaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerRequest, T> g) {
        return obj -> g.apply((CreateListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateListenerRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
         * request that completed successfully using the same client token and parameters, the retry succeeds without
         * performing any actions. If the parameters aren't identical, the retry fails.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        retry a request that completed successfully using the same client token and parameters, the retry
         *        succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The action for the default rule. Each listener has a default rule. Each rule consists of a priority, one or
         * more actions, and one or more conditions. The default rule is the rule that's used if no other rules match.
         * Each rule must include exactly one of the following types of actions: <code>forward </code>or
         * <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * 
         * @param defaultAction
         *        The action for the default rule. Each listener has a default rule. Each rule consists of a priority,
         *        one or more actions, and one or more conditions. The default rule is the rule that's used if no other
         *        rules match. Each rule must include exactly one of the following types of actions:
         *        <code>forward </code>or <code>fixed-response</code>, and it must be the last action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(RuleAction defaultAction);

        /**
         * <p>
         * The action for the default rule. Each listener has a default rule. Each rule consists of a priority, one or
         * more actions, and one or more conditions. The default rule is the rule that's used if no other rules match.
         * Each rule must include exactly one of the following types of actions: <code>forward </code>or
         * <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleAction.Builder} avoiding the need to
         * create one manually via {@link RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleAction.Builder#build()} is called immediately and its result
         * is passed to {@link #defaultAction(RuleAction)}.
         * 
         * @param defaultAction
         *        a consumer that will call methods on {@link RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAction(RuleAction)
         */
        default Builder defaultAction(Consumer<RuleAction.Builder> defaultAction) {
            return defaultAction(RuleAction.builder().applyMutation(defaultAction).build());
        }

        /**
         * <p>
         * The name of the listener. A listener name must be unique within a service. The valid characters are a-z, 0-9,
         * and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         * </p>
         * 
         * @param name
         *        The name of the listener. A listener name must be unique within a service. The valid characters are
         *        a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after
         *        another hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The listener port. You can specify a value from <code>1</code> to <code>65535</code>. For HTTP, the default
         * is <code>80</code>. For HTTPS, the default is <code>443</code>.
         * </p>
         * 
         * @param port
         *        The listener port. You can specify a value from <code>1</code> to <code>65535</code>. For HTTP, the
         *        default is <code>80</code>. For HTTPS, the default is <code>443</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The listener protocol HTTP or HTTPS.
         * </p>
         * 
         * @param protocol
         *        The listener protocol HTTP or HTTPS.
         * @see ListenerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListenerProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The listener protocol HTTP or HTTPS.
         * </p>
         * 
         * @param protocol
         *        The listener protocol HTTP or HTTPS.
         * @see ListenerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListenerProtocol
         */
        Builder protocol(ListenerProtocol protocol);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        /**
         * <p>
         * The tags for the listener.
         * </p>
         * 
         * @param tags
         *        The tags for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String clientToken;

        private RuleAction defaultAction;

        private String name;

        private Integer port;

        private String protocol;

        private String serviceIdentifier;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            super(model);
            clientToken(model.clientToken);
            defaultAction(model.defaultAction);
            name(model.name);
            port(model.port);
            protocol(model.protocol);
            serviceIdentifier(model.serviceIdentifier);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final RuleAction.Builder getDefaultAction() {
            return defaultAction != null ? defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(RuleAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(RuleAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ListenerProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
