/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFraudstersRequest extends VoiceIdRequest implements
        ToCopyableBuilder<ListFraudstersRequest.Builder, ListFraudstersRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(ListFraudstersRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFraudstersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFraudstersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> WATCHLIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WatchlistId").getter(getter(ListFraudstersRequest::watchlistId)).setter(setter(Builder::watchlistId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, WATCHLIST_ID_FIELD));

    private final String domainId;

    private final Integer maxResults;

    private final String nextToken;

    private final String watchlistId;

    private ListFraudstersRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.watchlistId = builder.watchlistId;
    }

    /**
     * <p>
     * The identifier of the domain.
     * </p>
     * 
     * @return The identifier of the domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages
     * of results. The default is 100; the maximum allowed page size is also 100.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
     *         more pages of results. The default is 100; the maximum allowed page size is also 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the watchlist. If provided, all fraudsters in the watchlist are listed. If not provided, all
     * fraudsters in the domain are listed.
     * </p>
     * 
     * @return The identifier of the watchlist. If provided, all fraudsters in the watchlist are listed. If not
     *         provided, all fraudsters in the domain are listed.
     */
    public final String watchlistId() {
        return watchlistId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(watchlistId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFraudstersRequest)) {
            return false;
        }
        ListFraudstersRequest other = (ListFraudstersRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(watchlistId(), other.watchlistId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFraudstersRequest").add("DomainId", domainId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("WatchlistId", watchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WatchlistId":
            return Optional.ofNullable(clazz.cast(watchlistId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFraudstersRequest, T> g) {
        return obj -> g.apply((ListFraudstersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFraudstersRequest> {
        /**
         * <p>
         * The identifier of the domain.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more
         * pages of results. The default is 100; the maximum allowed page size is also 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
         *        more pages of results. The default is 100; the maximum allowed page size is also 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the watchlist. If provided, all fraudsters in the watchlist are listed. If not provided,
         * all fraudsters in the domain are listed.
         * </p>
         * 
         * @param watchlistId
         *        The identifier of the watchlist. If provided, all fraudsters in the watchlist are listed. If not
         *        provided, all fraudsters in the domain are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchlistId(String watchlistId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VoiceIdRequest.BuilderImpl implements Builder {
        private String domainId;

        private Integer maxResults;

        private String nextToken;

        private String watchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFraudstersRequest model) {
            super(model);
            domainId(model.domainId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            watchlistId(model.watchlistId);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWatchlistId() {
            return watchlistId;
        }

        public final void setWatchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
        }

        @Override
        public final Builder watchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFraudstersRequest build() {
            return new ListFraudstersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
