/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityReference;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyFilter> {
    private static final SdkField<EntityReference> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(PolicyFilter.getter(PolicyFilter::principal)).setter(PolicyFilter.setter(Builder::principal)).constructor(EntityReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<EntityReference> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(PolicyFilter.getter(PolicyFilter::resource)).setter(PolicyFilter.setter(Builder::resource)).constructor(EntityReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(PolicyFilter.getter(PolicyFilter::policyTypeAsString)).setter(PolicyFilter.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyTemplateId").getter(PolicyFilter.getter(PolicyFilter::policyTemplateId)).setter(PolicyFilter.setter(Builder::policyTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, RESOURCE_FIELD, POLICY_TYPE_FIELD, POLICY_TEMPLATE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final EntityReference principal;
    private final EntityReference resource;
    private final String policyType;
    private final String policyTemplateId;

    private PolicyFilter(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.policyType = builder.policyType;
        this.policyTemplateId = builder.policyTemplateId;
    }

    public final EntityReference principal() {
        return this.principal;
    }

    public final EntityReference resource() {
        return this.resource;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final String policyTemplateId() {
        return this.policyTemplateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTemplateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyFilter)) {
            return false;
        }
        PolicyFilter other = (PolicyFilter)obj;
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.policyTemplateId(), other.policyTemplateId());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyFilter").add("Principal", (Object)this.principal()).add("Resource", (Object)this.resource()).add("PolicyType", (Object)this.policyTypeAsString()).add("PolicyTemplateId", (Object)this.policyTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "policyTemplateId": {
                return Optional.ofNullable(clazz.cast(this.policyTemplateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyFilter, T> g) {
        return obj -> g.apply((PolicyFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntityReference principal;
        private EntityReference resource;
        private String policyType;
        private String policyTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyFilter model) {
            this.principal(model.principal);
            this.resource(model.resource);
            this.policyType(model.policyType);
            this.policyTemplateId(model.policyTemplateId);
        }

        public final EntityReference.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityReference.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityReference principal) {
            this.principal = principal;
            return this;
        }

        public final EntityReference.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(EntityReference.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityReference resource) {
            this.resource = resource;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyTemplateId() {
            return this.policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public PolicyFilter build() {
            return new PolicyFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyFilter> {
        public Builder principal(EntityReference var1);

        default public Builder principal(Consumer<EntityReference.Builder> principal) {
            return this.principal((EntityReference)((EntityReference.Builder)EntityReference.builder().applyMutation(principal)).build());
        }

        public Builder resource(EntityReference var1);

        default public Builder resource(Consumer<EntityReference.Builder> resource) {
            return this.resource((EntityReference)((EntityReference.Builder)EntityReference.builder().applyMutation(resource)).build());
        }

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder policyTemplateId(String var1);
    }
}

