/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationLanguage {
    EN("en"),
    JA("ja"),
    ZH("zh"),
    FR("fr"),
    DE("de"),
    KO("ko"),
    ZH_TW("zh_TW"),
    IT("it"),
    ES("es"),
    PT_BR("pt_BR"),
    ID("id"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationLanguage> VALUE_MAP;
    private final String value;

    private RecommendationLanguage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationLanguage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationLanguage> knownValues() {
        EnumSet<RecommendationLanguage> knownValues = EnumSet.allOf(RecommendationLanguage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationLanguage.class, RecommendationLanguage::toString);
    }
}

