/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaEncoding {
    PCM("pcm"),
    OGG_OPUS("ogg-opus"),
    FLAC("flac"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaEncoding> VALUE_MAP;
    private final String value;

    private MediaEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaEncoding> knownValues() {
        EnumSet<MediaEncoding> knownValues = EnumSet.allOf(MediaEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaEncoding.class, MediaEncoding::toString);
    }
}

