/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTranscriptionJobsRequest extends TranscribeRequest implements
        ToCopyableBuilder<ListTranscriptionJobsRequest.Builder, ListTranscriptionJobsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListTranscriptionJobsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> JOB_NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobNameContains").getter(getter(ListTranscriptionJobsRequest::jobNameContains))
            .setter(setter(Builder::jobNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNameContains").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTranscriptionJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTranscriptionJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            JOB_NAME_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String status;

    private final String jobNameContains;

    private final String nextToken;

    private final Integer maxResults;

    private ListTranscriptionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.jobNameContains = builder.jobNameContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job
     * first. If you don't include <code>Status</code>, all transcription jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the
     *         newest job first. If you don't include <code>Status</code>, all transcription jobs are returned.
     * @see TranscriptionJobStatus
     */
    public final TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job
     * first. If you don't include <code>Status</code>, all transcription jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the
     *         newest job first. If you don't include <code>Status</code>, all transcription jobs are returned.
     * @see TranscriptionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returns only the transcription jobs that contain the specified string. The search is not case sensitive.
     * </p>
     * 
     * @return Returns only the transcription jobs that contain the specified string. The search is not case sensitive.
     */
    public final String jobNameContains() {
        return jobNameContains;
    }

    /**
     * <p>
     * If your <code>ListTranscriptionJobs</code> request returns more results than can be displayed,
     * <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results,
     * copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string.
     * Repeat as needed to view all your results.
     * </p>
     * 
     * @return If your <code>ListTranscriptionJobs</code> request returns more results than can be displayed,
     *         <code>NextToken</code> is displayed in the response with an associated string. To get the next page of
     *         results, copy this string and repeat your request, including <code>NextToken</code> with the value of the
     *         copied string. Repeat as needed to view all your results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of transcription jobs to return in each page of results. If there are fewer results than the
     * value that you specify, only the actual results are returned. If you don't specify a value, a default of 5 is
     * used.
     * </p>
     * 
     * @return The maximum number of transcription jobs to return in each page of results. If there are fewer results
     *         than the value that you specify, only the actual results are returned. If you don't specify a value, a
     *         default of 5 is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTranscriptionJobsRequest)) {
            return false;
        }
        ListTranscriptionJobsRequest other = (ListTranscriptionJobsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(jobNameContains(), other.jobNameContains()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTranscriptionJobsRequest").add("Status", statusAsString())
                .add("JobNameContains", jobNameContains()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "JobNameContains":
            return Optional.ofNullable(clazz.cast(jobNameContains()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTranscriptionJobsRequest, T> g) {
        return obj -> g.apply((ListTranscriptionJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTranscriptionJobsRequest> {
        /**
         * <p>
         * Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest
         * job first. If you don't include <code>Status</code>, all transcription jobs are returned.
         * </p>
         * 
         * @param status
         *        Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the
         *        newest job first. If you don't include <code>Status</code>, all transcription jobs are returned.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest
         * job first. If you don't include <code>Status</code>, all transcription jobs are returned.
         * </p>
         * 
         * @param status
         *        Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the
         *        newest job first. If you don't include <code>Status</code>, all transcription jobs are returned.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(TranscriptionJobStatus status);

        /**
         * <p>
         * Returns only the transcription jobs that contain the specified string. The search is not case sensitive.
         * </p>
         * 
         * @param jobNameContains
         *        Returns only the transcription jobs that contain the specified string. The search is not case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNameContains(String jobNameContains);

        /**
         * <p>
         * If your <code>ListTranscriptionJobs</code> request returns more results than can be displayed,
         * <code>NextToken</code> is displayed in the response with an associated string. To get the next page of
         * results, copy this string and repeat your request, including <code>NextToken</code> with the value of the
         * copied string. Repeat as needed to view all your results.
         * </p>
         * 
         * @param nextToken
         *        If your <code>ListTranscriptionJobs</code> request returns more results than can be displayed,
         *        <code>NextToken</code> is displayed in the response with an associated string. To get the next page of
         *        results, copy this string and repeat your request, including <code>NextToken</code> with the value of
         *        the copied string. Repeat as needed to view all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of transcription jobs to return in each page of results. If there are fewer results than
         * the value that you specify, only the actual results are returned. If you don't specify a value, a default of
         * 5 is used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of transcription jobs to return in each page of results. If there are fewer results
         *        than the value that you specify, only the actual results are returned. If you don't specify a value, a
         *        default of 5 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String status;

        private String jobNameContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTranscriptionJobsRequest model) {
            super(model);
            status(model.status);
            jobNameContains(model.jobNameContains);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJobNameContains() {
            return jobNameContains;
        }

        public final void setJobNameContains(String jobNameContains) {
            this.jobNameContains = jobNameContains;
        }

        @Override
        public final Builder jobNameContains(String jobNameContains) {
            this.jobNameContains = jobNameContains;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTranscriptionJobsRequest build() {
            return new ListTranscriptionJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
